/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.client.gui.screen.presetconfig;

import java.util.Optional;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.network.chat.Component;
import raccoonman.reterraforged.client.data.RTFTranslationKeys;
import raccoonman.reterraforged.client.gui.screen.page.LinkedPageScreen;
import raccoonman.reterraforged.client.gui.screen.presetconfig.PresetConfigScreen;
import raccoonman.reterraforged.client.gui.screen.presetconfig.PresetEditorPage;
import raccoonman.reterraforged.client.gui.screen.presetconfig.PresetListPage;
import raccoonman.reterraforged.client.gui.screen.presetconfig.PresetWidgets;
import raccoonman.reterraforged.client.gui.screen.presetconfig.StructureSettingsPage;
import raccoonman.reterraforged.client.gui.widget.Slider;
import raccoonman.reterraforged.data.worldgen.preset.settings.MiscellaneousSettings;
import raccoonman.reterraforged.data.worldgen.preset.settings.Preset;

public class MiscellaneousPage
extends PresetEditorPage {
    private CycleButton<Boolean> smoothLayerDecorator;
    private Slider strataRegionSize;
    private CycleButton<Boolean> strataDecorator;
    private CycleButton<Boolean> oreCompatibleStoneOnly;
    private CycleButton<Boolean> erosionDecorator;
    private CycleButton<Boolean> plainStoneErosion;
    private CycleButton<Boolean> naturalSnowDecorator;
    private CycleButton<Boolean> customBiomeFeatures;
    private CycleButton<Boolean> vanillaSprings;
    private CycleButton<Boolean> vanillaLavaLakes;
    private CycleButton<Boolean> vanillaLavaSprings;
    private Slider mountainBiomeUsage;
    private Slider volcanoBiomeUsage;

    public MiscellaneousPage(PresetConfigScreen screen, PresetListPage.PresetEntry preset) {
        super(screen, preset);
    }

    @Override
    public Component title() {
        return Component.m_237115_((String)RTFTranslationKeys.GUI_MISCELLANEOUS_SETTINGS_TITLE);
    }

    @Override
    public void init() {
        super.init();
        Preset preset = this.preset.getPreset();
        MiscellaneousSettings miscellaneous = preset.miscellaneous();
        this.smoothLayerDecorator = PresetWidgets.createToggle(miscellaneous.smoothLayerDecorator, RTFTranslationKeys.GUI_BUTTON_SMOOTH_LAYER_DECORATOR, (CycleButton.OnValueChange<Boolean>)((CycleButton.OnValueChange)(button, value) -> {
            miscellaneous.smoothLayerDecorator = value;
        }));
        this.strataRegionSize = PresetWidgets.createIntSlider(miscellaneous.strataRegionSize, 50, 1000, RTFTranslationKeys.GUI_SLIDER_STRATA_REGION_SIZE, (slider, value) -> {
            miscellaneous.strataRegionSize = (int)slider.scaleValue(value);
            return value;
        });
        this.strataDecorator = PresetWidgets.createToggle(miscellaneous.strataDecorator, RTFTranslationKeys.GUI_BUTTON_STRATA_DECORATOR, (CycleButton.OnValueChange<Boolean>)((CycleButton.OnValueChange)(button, value) -> {
            miscellaneous.strataDecorator = value;
        }));
        this.oreCompatibleStoneOnly = PresetWidgets.createToggle(miscellaneous.oreCompatibleStoneOnly, RTFTranslationKeys.GUI_BUTTON_ORE_COMPATIBLE_STONE_ONLY, (CycleButton.OnValueChange<Boolean>)((CycleButton.OnValueChange)(button, value) -> {
            miscellaneous.oreCompatibleStoneOnly = value;
        }));
        this.erosionDecorator = PresetWidgets.createToggle(miscellaneous.erosionDecorator, RTFTranslationKeys.GUI_BUTTON_EROSION_DECORATOR, (CycleButton.OnValueChange<Boolean>)((CycleButton.OnValueChange)(button, value) -> {
            miscellaneous.erosionDecorator = value;
        }));
        this.plainStoneErosion = PresetWidgets.createToggle(miscellaneous.plainStoneErosion, RTFTranslationKeys.GUI_BUTTON_PLAIN_STONE_EROSION, (CycleButton.OnValueChange<Boolean>)((CycleButton.OnValueChange)(button, value) -> {
            miscellaneous.plainStoneErosion = value;
        }));
        this.naturalSnowDecorator = PresetWidgets.createToggle(miscellaneous.naturalSnowDecorator, RTFTranslationKeys.GUI_BUTTON_NATURAL_SNOW_DECORATOR, (CycleButton.OnValueChange<Boolean>)((CycleButton.OnValueChange)(button, value) -> {
            miscellaneous.naturalSnowDecorator = value;
        }));
        this.customBiomeFeatures = PresetWidgets.createToggle(miscellaneous.customBiomeFeatures, RTFTranslationKeys.GUI_BUTTON_CUSTOM_BIOME_FEATURES, (CycleButton.OnValueChange<Boolean>)((CycleButton.OnValueChange)(button, value) -> {
            miscellaneous.customBiomeFeatures = value;
        }));
        this.vanillaSprings = PresetWidgets.createToggle(miscellaneous.vanillaSprings, RTFTranslationKeys.GUI_BUTTON_VANILLA_SPRINGS, (CycleButton.OnValueChange<Boolean>)((CycleButton.OnValueChange)(button, value) -> {
            miscellaneous.vanillaSprings = value;
        }));
        this.vanillaLavaLakes = PresetWidgets.createToggle(miscellaneous.vanillaLavaLakes, RTFTranslationKeys.GUI_BUTTON_VANILLA_LAVA_LAKES, (CycleButton.OnValueChange<Boolean>)((CycleButton.OnValueChange)(button, value) -> {
            miscellaneous.vanillaLavaLakes = value;
        }));
        this.vanillaLavaSprings = PresetWidgets.createToggle(miscellaneous.vanillaLavaSprings, RTFTranslationKeys.GUI_BUTTON_VANILLA_LAVA_SPRINGS, (CycleButton.OnValueChange<Boolean>)((CycleButton.OnValueChange)(button, value) -> {
            miscellaneous.vanillaLavaSprings = value;
        }));
        this.mountainBiomeUsage = PresetWidgets.createFloatSlider(miscellaneous.mountainBiomeUsage, 0.0f, 1.0f, RTFTranslationKeys.GUI_SLIDER_MOUNTAIN_BIOME_USAGE, (slider, value) -> {
            miscellaneous.mountainBiomeUsage = (float)slider.scaleValue(value);
            return value;
        });
        this.volcanoBiomeUsage = PresetWidgets.createFloatSlider(miscellaneous.volcanoBiomeUsage, 0.0f, 1.0f, RTFTranslationKeys.GUI_SLIDER_VOLCANO_BIOME_USAGE, (slider, value) -> {
            miscellaneous.volcanoBiomeUsage = (float)slider.scaleValue(value);
            return value;
        });
        this.left.addWidget(this.smoothLayerDecorator);
        this.left.addWidget(this.strataRegionSize);
        this.left.addWidget(this.strataDecorator);
        this.left.addWidget(this.oreCompatibleStoneOnly);
        this.left.addWidget(this.erosionDecorator);
        this.left.addWidget(this.plainStoneErosion);
        this.left.addWidget(this.naturalSnowDecorator);
        this.left.addWidget(this.customBiomeFeatures);
        this.left.addWidget(this.vanillaSprings);
        this.left.addWidget(this.vanillaLavaLakes);
        this.left.addWidget(this.vanillaLavaSprings);
        this.left.addWidget(this.mountainBiomeUsage);
        this.left.addWidget(this.volcanoBiomeUsage);
    }

    @Override
    public Optional<LinkedPageScreen.Page> previous() {
        return Optional.of(new StructureSettingsPage((PresetConfigScreen)this.screen, this.preset));
    }

    @Override
    public Optional<LinkedPageScreen.Page> next() {
        return Optional.empty();
    }
}

