/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.client.gui.screen.presetconfig;

import java.awt.Color;
import raccoonman.reterraforged.world.worldgen.cell.Cell;
import raccoonman.reterraforged.world.worldgen.cell.heightmap.Levels;
import raccoonman.reterraforged.world.worldgen.noise.NoiseUtil;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum RenderMode {
    BIOME_TYPE{

        @Override
        public boolean handlesWater() {
            return true;
        }

        @Override
        public int getColor(Cell cell, Levels levels, float scale, float bias) {
            switch (cell.terrain.getCategory()) {
                case DEEP_OCEAN: {
                    return RenderMode.rgba(0.63f, 0.65f, 0.8f);
                }
                case SHALLOW_OCEAN: {
                    return RenderMode.rgba(0.6f, 0.6f, 0.8f);
                }
                case BEACH: {
                    return RenderMode.rgba(0.2f, 0.4f, 0.75f);
                }
            }
            if (cell.height < levels.water) {
                return RenderMode.getWaterColor();
            }
            Color color = cell.biome.getColor();
            float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3]);
            return RenderMode.rgba(hsb[0], hsb[1], hsb[2] * scale + bias);
        }
    }
    ,
    TRANSITION_POINTS{

        @Override
        public boolean handlesWater() {
            return true;
        }

        @Override
        public int getColor(Cell cell, Levels levels, float scale, float bias) {
            switch (cell.terrain.getCategory()) {
                case DEEP_OCEAN: {
                    return RenderMode.rgba(0.63f, 0.65f, 0.8f);
                }
                case SHALLOW_OCEAN: {
                    return RenderMode.rgba(0.6f, 0.6f, 0.8f);
                }
                case BEACH: {
                    return RenderMode.rgba(0.2f, 0.4f, 0.75f);
                }
                case COAST: {
                    return RenderMode.rgba(0.35f, 0.75f, 0.65f);
                }
            }
            if (cell.terrain.isRiver() || cell.terrain.isWetland()) {
                return RenderMode.rgba(0.6f, 0.6f, 0.8f);
            }
            return RenderMode.rgba(0.3f, 0.7f, 0.5f);
        }
    }
    ,
    TEMPERATURE{

        @Override
        public int getColor(Cell cell, Levels levels, float scale, float bias) {
            float saturation = 0.7f;
            float brightness = 0.8f;
            return RenderMode.rgba(RenderMode.step(1.0f - cell.regionTemperature, 8) * 0.65f, saturation, brightness);
        }
    }
    ,
    MOISTURE{

        @Override
        public int getColor(Cell cell, Levels levels, float scale, float bias) {
            float saturation = 0.7f;
            float brightness = 0.8f;
            return RenderMode.rgba(RenderMode.step(cell.regionMoisture, 8) * 0.65f, saturation, brightness);
        }
    }
    ,
    BIOME{

        @Override
        public int getColor(Cell cell, Levels levels, float scale, float bias) {
            float saturation = 0.7f;
            float brightness = 0.8f;
            return RenderMode.rgba(cell.biomeRegionId, saturation, brightness);
        }
    }
    ,
    MACRO_NOISE{

        @Override
        public int getColor(Cell cell, Levels levels, float scale, float bias) {
            float saturation = 0.7f;
            float brightness = 0.8f;
            return RenderMode.rgba(cell.macroBiomeId, saturation, brightness);
        }
    }
    ,
    TERRAIN_REGION{

        @Override
        public int getColor(Cell cell, Levels levels, float scale, float bias) {
            float saturation = 0.7f;
            float brightness = 0.8f;
            return RenderMode.rgba(cell.terrain.getRenderHue(), saturation, brightness);
        }
    };


    public int getColor(Cell cell, Levels levels) {
        if (!this.handlesWater() && cell.height < levels.water) {
            return RenderMode.getWaterColor();
        }
        float bands = 10.0f;
        float alpha = 0.2f;
        float elevation = (cell.height - levels.water) / (1.0f - levels.water);
        int band = NoiseUtil.round(elevation * bands);
        float scale = 1.0f - alpha;
        float bias = alpha * ((float)band / bands);
        return this.getColor(cell, levels, scale, bias);
    }

    public abstract int getColor(Cell var1, Levels var2, float var3, float var4);

    public boolean handlesWater() {
        return false;
    }

    private static int getWaterColor() {
        return RenderMode.rgba(40, 140, 200);
    }

    private static float step(float value, int steps) {
        return (float)NoiseUtil.round(value * (float)steps) / (float)steps;
    }

    private static int rgba(float h, float s, float b) {
        int argb = Color.HSBtoRGB(h, s, b);
        int red = argb >> 16 & 0xFF;
        int green = argb >> 8 & 0xFF;
        int blue = argb & 0xFF;
        return RenderMode.rgba(red, green, blue);
    }

    private static int rgba(int r, int g, int b) {
        return r + (g << 8) + (b << 16) + -16777216;
    }
}

