/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.client.gui.screen.presetconfig;

import java.util.Optional;
import java.util.Set;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import raccoonman.reterraforged.client.data.RTFTranslationKeys;
import raccoonman.reterraforged.client.gui.screen.page.LinkedPageScreen;
import raccoonman.reterraforged.client.gui.screen.presetconfig.FilterSettingsPage;
import raccoonman.reterraforged.client.gui.screen.presetconfig.MiscellaneousPage;
import raccoonman.reterraforged.client.gui.screen.presetconfig.PresetConfigScreen;
import raccoonman.reterraforged.client.gui.screen.presetconfig.PresetEditorPage;
import raccoonman.reterraforged.client.gui.screen.presetconfig.PresetListPage;
import raccoonman.reterraforged.client.gui.screen.presetconfig.PresetWidgets;
import raccoonman.reterraforged.client.gui.widget.Slider;
import raccoonman.reterraforged.client.gui.widget.ValueButton;
import raccoonman.reterraforged.data.worldgen.preset.settings.Preset;
import raccoonman.reterraforged.data.worldgen.preset.settings.StructureSettings;

public class StructureSettingsPage
extends PresetEditorPage {
    public StructureSettingsPage(PresetConfigScreen screen, PresetListPage.PresetEntry preset) {
        super(screen, preset);
    }

    @Override
    public Component title() {
        return Component.m_237115_((String)RTFTranslationKeys.GUI_STRUCTURE_SETTINGS_TITLE);
    }

    @Override
    public void init() {
        super.init();
        Preset preset = this.preset.getPreset();
        StructureSettings structures = preset.structures();
        WorldCreationContext settings = ((PresetConfigScreen)this.screen).getSettings();
        RegistryAccess.Frozen registries = settings.m_246480_();
        registries.m_255025_(Registries.f_256998_).m_214062_().filter(holder -> StructureSettingsPage.isOverworldStructureSet(settings.f_243796_(), (Holder.Reference<StructureSet>)holder)).forEach(holder -> {
            StructureSet set = (StructureSet)holder.m_203334_();
            StructurePlacement patt2274$temp = set.f_210004_();
            if (patt2274$temp instanceof RandomSpreadStructurePlacement) {
                RandomSpreadStructurePlacement placement = (RandomSpreadStructurePlacement)patt2274$temp;
                structures.entries.computeIfAbsent((ResourceKey<StructureSet>)holder.m_205785_(), k -> new StructureSettings.StructureSetEntry(placement.m_205003_(), placement.m_205004_(), placement.m_227075_(), false));
            }
        });
        structures.entries.forEach((key, entry) -> {
            Slider separation;
            class SliderHolder {
                Slider slider;

                SliderHolder() {
                }
            }
            SliderHolder seperationHolder = new SliderHolder();
            Slider spacing = PresetWidgets.createIntSlider(entry.spacing, 0, 1000, RTFTranslationKeys.GUI_SLIDER_SPACING, (slider, value) -> {
                value = Math.max(value, seperationHolder.slider.getValue() + slider.getSliderValue(1.0f));
                entry.spacing = (int)slider.scaleValue((float)value);
                return value;
            });
            seperationHolder.slider = separation = PresetWidgets.createIntSlider(entry.separation, 0, 1000, RTFTranslationKeys.GUI_SLIDER_SEPARATION, (slider, value) -> {
                value = Math.min(value, spacing.getValue() - slider.getSliderValue(1.0f));
                entry.separation = (int)slider.scaleValue((float)value);
                return value;
            });
            ValueButton<Integer> salt = PresetWidgets.createRandomButton(RTFTranslationKeys.GUI_BUTTON_SALT, entry.salt, value -> {
                entry.salt = value;
            });
            CycleButton<Boolean> disabled = PresetWidgets.createToggle(entry.disabled, RTFTranslationKeys.GUI_BUTTON_DISABLED, (CycleButton.OnValueChange<Boolean>)((CycleButton.OnValueChange)(button, value) -> {
                entry.disabled = value;
            }));
            this.left.addWidget(PresetWidgets.createLabel(key.m_135782_().toString()));
            this.left.addWidget(spacing);
            this.left.addWidget(separation);
            this.left.addWidget(salt);
            this.left.addWidget(disabled);
        });
    }

    @Override
    public Optional<LinkedPageScreen.Page> previous() {
        return Optional.of(new FilterSettingsPage((PresetConfigScreen)this.screen, this.preset));
    }

    @Override
    public Optional<LinkedPageScreen.Page> next() {
        return Optional.of(new MiscellaneousPage((PresetConfigScreen)this.screen, this.preset));
    }

    private static boolean isOverworldStructureSet(WorldDimensions dimensions, Holder.Reference<StructureSet> holder) {
        Set overworldBiomes = dimensions.m_246737_().m_62218_().m_207840_();
        for (StructureSet.StructureSelectionEntry structureEntry : ((StructureSet)holder.m_203334_()).f_210003_()) {
            Structure structure = (Structure)structureEntry.f_210026_().m_203334_();
            for (Holder biome : structure.m_226559_()) {
                if (!overworldBiomes.contains(biome)) continue;
                return true;
            }
        }
        return false;
    }
}

