/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.client.gui.screen.presetconfig;

import java.util.Optional;
import net.minecraft.network.chat.Component;
import raccoonman.reterraforged.client.data.RTFTranslationKeys;
import raccoonman.reterraforged.client.gui.screen.page.LinkedPageScreen;
import raccoonman.reterraforged.client.gui.screen.presetconfig.CaveSettingsPage;
import raccoonman.reterraforged.client.gui.screen.presetconfig.PresetConfigScreen;
import raccoonman.reterraforged.client.gui.screen.presetconfig.PresetEditorPage;
import raccoonman.reterraforged.client.gui.screen.presetconfig.PresetListPage;
import raccoonman.reterraforged.client.gui.screen.presetconfig.PresetWidgets;
import raccoonman.reterraforged.client.gui.screen.presetconfig.WorldSettingsPage;
import raccoonman.reterraforged.client.gui.widget.Slider;
import raccoonman.reterraforged.data.worldgen.preset.settings.Preset;
import raccoonman.reterraforged.data.worldgen.preset.settings.SurfaceSettings;

public class SurfaceSettingsPage
extends PresetEditorPage {
    private Slider rockVariance;
    private Slider rockMin;
    private Slider dirtVariance;
    private Slider dirtMin;
    private Slider rockSteepness;
    private Slider dirtSteepness;
    private Slider screeSteepness;

    public SurfaceSettingsPage(PresetConfigScreen screen, PresetListPage.PresetEntry preset) {
        super(screen, preset);
    }

    @Override
    public Component title() {
        return Component.m_237115_((String)RTFTranslationKeys.GUI_SURFACE_SETTINGS_TITLE);
    }

    @Override
    public void init() {
        super.init();
        Preset preset = this.preset.getPreset();
        SurfaceSettings surface = preset.surface();
        SurfaceSettings.Erosion erosion = surface.erosion();
        this.rockVariance = PresetWidgets.createIntSlider(erosion.rockVariance, 0, 256, RTFTranslationKeys.GUI_SLIDER_ROCK_VARIANCE, (slider, value) -> {
            erosion.rockVariance = (int)slider.scaleValue(value);
            return value;
        });
        this.rockMin = PresetWidgets.createIntSlider(erosion.rockMin, -1024, 1024, RTFTranslationKeys.GUI_SLIDER_ROCK_MIN, (slider, value) -> {
            erosion.rockMin = (int)slider.scaleValue(value);
            return value;
        });
        this.dirtVariance = PresetWidgets.createIntSlider(erosion.dirtVariance, 0, 256, RTFTranslationKeys.GUI_SLIDER_DIRT_VARIANCE, (slider, value) -> {
            erosion.dirtVariance = (int)slider.scaleValue(value);
            return value;
        });
        this.dirtMin = PresetWidgets.createIntSlider(erosion.dirtMin, -1024, 1024, RTFTranslationKeys.GUI_SLIDER_DIRT_MIN, (slider, value) -> {
            erosion.dirtMin = (int)slider.scaleValue(value);
            return value;
        });
        this.rockSteepness = PresetWidgets.createFloatSlider(erosion.rockSteepness, 0.0f, 3.0f, RTFTranslationKeys.GUI_SLIDER_ROCK_STEEPNESS, (slider, value) -> {
            erosion.rockSteepness = (float)slider.scaleValue(value);
            return value;
        });
        this.dirtSteepness = PresetWidgets.createFloatSlider(erosion.dirtSteepness, 0.0f, 3.0f, RTFTranslationKeys.GUI_SLIDER_DIRT_STEEPNESS, (slider, value) -> {
            erosion.dirtSteepness = (float)slider.scaleValue(value);
            return value;
        });
        this.screeSteepness = PresetWidgets.createFloatSlider(erosion.screeSteepness, 0.0f, 3.0f, RTFTranslationKeys.GUI_SLIDER_SCREE_STEEPNESS, (slider, value) -> {
            erosion.screeSteepness = (float)slider.scaleValue(value);
            return value;
        });
        this.left.addWidget(PresetWidgets.createLabel(RTFTranslationKeys.GUI_LABEL_SURFACE_EROSION));
        this.left.addWidget(this.rockVariance);
        this.left.addWidget(this.rockMin);
        this.left.addWidget(this.dirtVariance);
        this.left.addWidget(this.dirtMin);
        this.left.addWidget(this.rockSteepness);
        this.left.addWidget(this.dirtSteepness);
        this.left.addWidget(this.screeSteepness);
    }

    @Override
    public Optional<LinkedPageScreen.Page> previous() {
        return Optional.of(new WorldSettingsPage((PresetConfigScreen)this.screen, this.preset));
    }

    @Override
    public Optional<LinkedPageScreen.Page> next() {
        return Optional.of(new CaveSettingsPage((PresetConfigScreen)this.screen, this.preset));
    }
}

