/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.data.worldgen;

import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.SharedConstants;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import raccoonman.reterraforged.client.data.RTFTranslationKeys;
import raccoonman.reterraforged.data.worldgen.preset.PresetConfiguredFeatures;
import raccoonman.reterraforged.data.worldgen.preset.settings.Preset;
import raccoonman.reterraforged.data.worldgen.tags.RTFBlockTagsProvider;
import raccoonman.reterraforged.data.worldgen.tags.RTFDensityFunctionTagsProvider;
import raccoonman.reterraforged.platform.DataGenUtil;
import raccoonman.reterraforged.world.worldgen.feature.RTFFeatures;
import raccoonman.reterraforged.world.worldgen.feature.SwampSurfaceFeature;

public class Datapacks {
    public static DataGenerator makeMudSwamps(RegistryAccess registryAccess, Path dataGenPath, Path dataGenOutputPath) {
        DataGenerator dataGenerator;
        DataGenerator dataGenerator2 = dataGenerator = new DataGenerator(dataGenPath, SharedConstants.m_183709_(), true);
        Objects.requireNonNull(dataGenerator2);
        DataGenerator.PackGenerator packGenerator = new DataGenerator.PackGenerator(dataGenerator2, true, "Mud Swamps", new PackOutput(dataGenOutputPath));
        CompletableFuture<HolderLookup.Provider> lookup = CompletableFuture.supplyAsync(() -> {
            RegistrySetBuilder builder = new RegistrySetBuilder();
            builder.m_254916_(Registries.f_256911_, ctx -> FeatureUtils.m_254977_((BootstapContext)ctx, PresetConfiguredFeatures.SWAMP_SURFACE, RTFFeatures.SWAMP_SURFACE, (FeatureConfiguration)new SwampSurfaceFeature.Config(Blocks.f_50129_.m_49966_(), Blocks.f_49994_.m_49966_(), Blocks.f_220864_.m_49966_())));
            return builder.m_254929_((RegistryAccess)RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_), (HolderLookup.Provider)registryAccess);
        });
        packGenerator.m_253108_(output -> DataGenUtil.createRegistryProvider(output, lookup));
        packGenerator.m_253108_(output -> PackMetadataGenerator.m_254904_((PackOutput)output, (Component)Component.m_237115_((String)RTFTranslationKeys.MUD_SWAMPS_METADATA_DESCRIPTION)));
        return dataGenerator;
    }

    public static DataGenerator makePreset(Preset preset, RegistryAccess registryAccess, Path dataGenPath, Path dataGenOutputPath, String presetName) {
        DataGenerator dataGenerator;
        DataGenerator dataGenerator2 = dataGenerator = new DataGenerator(dataGenPath, SharedConstants.m_183709_(), true);
        Objects.requireNonNull(dataGenerator2);
        DataGenerator.PackGenerator packGenerator = new DataGenerator.PackGenerator(dataGenerator2, true, presetName, new PackOutput(dataGenOutputPath));
        CompletableFuture<HolderLookup.Provider> lookup = CompletableFuture.supplyAsync(() -> preset.buildPatch(registryAccess));
        packGenerator.m_253108_(output -> DataGenUtil.createRegistryProvider(output, lookup));
        packGenerator.m_253108_(output -> new RTFDensityFunctionTagsProvider(output, lookup));
        packGenerator.m_253108_(output -> new RTFBlockTagsProvider(preset, output, lookup));
        packGenerator.m_253108_(output -> PackMetadataGenerator.m_254904_((PackOutput)output, (Component)Component.m_237115_((String)RTFTranslationKeys.PRESET_METADATA_DESCRIPTION)));
        return dataGenerator;
    }
}

