/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.data.worldgen.preset;

import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import raccoonman.reterraforged.RTFCommon;
import raccoonman.reterraforged.data.worldgen.preset.PresetPlacedFeatures;
import raccoonman.reterraforged.data.worldgen.preset.settings.MiscellaneousSettings;
import raccoonman.reterraforged.data.worldgen.preset.settings.Preset;
import raccoonman.reterraforged.registries.RTFRegistries;
import raccoonman.reterraforged.world.worldgen.biome.modifier.BiomeModifier;
import raccoonman.reterraforged.world.worldgen.biome.modifier.BiomeModifiers;
import raccoonman.reterraforged.world.worldgen.biome.modifier.Filter;
import raccoonman.reterraforged.world.worldgen.biome.modifier.Order;

public class PresetBiomeModifierData {
    public static final ResourceKey<BiomeModifier> ADD_EROSION = PresetBiomeModifierData.createKey("add_erosion");
    public static final ResourceKey<BiomeModifier> ADD_SNOW_PROCESSING = PresetBiomeModifierData.createKey("add_snow_processing");
    public static final ResourceKey<BiomeModifier> ADD_SWAMP_SURFACE = PresetBiomeModifierData.createKey("add_swamp_surface");
    public static final ResourceKey<BiomeModifier> REPLACE_PLAINS_TREES = PresetBiomeModifierData.createKey("replace_plains_trees");
    public static final ResourceKey<BiomeModifier> REPLACE_FOREST_TREES = PresetBiomeModifierData.createKey("replace_forest_trees");
    public static final ResourceKey<BiomeModifier> REPLACE_FLOWER_FOREST_TREES = PresetBiomeModifierData.createKey("replace_flower_forest_trees");
    public static final ResourceKey<BiomeModifier> REPLACE_BIRCH_TREES = PresetBiomeModifierData.createKey("replace_birch_trees");
    public static final ResourceKey<BiomeModifier> REPLACE_DARK_FOREST_TREES = PresetBiomeModifierData.createKey("replace_dark_forest_trees");
    public static final ResourceKey<BiomeModifier> REPLACE_SAVANNA_TREES = PresetBiomeModifierData.createKey("replace_savanna_trees");
    public static final ResourceKey<BiomeModifier> REPLACE_SWAMP_TREES = PresetBiomeModifierData.createKey("replace_swamp_trees");
    public static final ResourceKey<BiomeModifier> REPLACE_MEADOW_TREES = PresetBiomeModifierData.createKey("replace_meadow_trees");
    public static final ResourceKey<BiomeModifier> REPLACE_FIR_TREES = PresetBiomeModifierData.createKey("replace_fir_trees");
    public static final ResourceKey<BiomeModifier> REPLACE_WINDSWEPT_HILLS_FIR_TREES = PresetBiomeModifierData.createKey("replace_windswept_hills_fir_trees");
    public static final ResourceKey<BiomeModifier> REPLACE_PINE_TREES = PresetBiomeModifierData.createKey("replace_pine_trees");
    public static final ResourceKey<BiomeModifier> REPLACE_SPRUCE_TREES = PresetBiomeModifierData.createKey("replace_spruce_trees");
    public static final ResourceKey<BiomeModifier> REPLACE_SPRUCE_TUNDRA_TREES = PresetBiomeModifierData.createKey("replace_spruce_tundra_trees");
    public static final ResourceKey<BiomeModifier> REPLACE_REDWOOD_TREES = PresetBiomeModifierData.createKey("replace_redwood_trees");
    public static final ResourceKey<BiomeModifier> REPLACE_JUNGLE_TREES = PresetBiomeModifierData.createKey("replace_jungle_trees");
    public static final ResourceKey<BiomeModifier> REPLACE_JUNGLE_EDGE_TREES = PresetBiomeModifierData.createKey("replace_jungle_edge_trees");
    public static final ResourceKey<BiomeModifier> REPLACE_BADLANDS_TREES = PresetBiomeModifierData.createKey("replace_badlands_trees");
    public static final ResourceKey<BiomeModifier> REPLACE_WOODED_BADLANDS_TREES = PresetBiomeModifierData.createKey("replace_wooded_badlands_trees");
    public static final ResourceKey<BiomeModifier> ADD_MARSH_BUSH = PresetBiomeModifierData.createKey("add_marsh_bush");
    public static final ResourceKey<BiomeModifier> ADD_PLAINS_BUSH = PresetBiomeModifierData.createKey("add_plains_bush");
    public static final ResourceKey<BiomeModifier> ADD_STEPPE_BUSH = PresetBiomeModifierData.createKey("add_stepps_bush");
    public static final ResourceKey<BiomeModifier> ADD_COLD_STEPPE_BUSH = PresetBiomeModifierData.createKey("add_cold_steppe_bush");
    public static final ResourceKey<BiomeModifier> ADD_TAIGA_SCRUB_BUSH = PresetBiomeModifierData.createKey("add_taiga_scrub_bush");
    public static final ResourceKey<BiomeModifier> ADD_FOREST_GRASS = PresetBiomeModifierData.createKey("add_forest_grass");
    public static final ResourceKey<BiomeModifier> ADD_BIRCH_FOREST_GRASS = PresetBiomeModifierData.createKey("add_birch_forest_grass");

    public static void bootstrap(Preset preset, BootstapContext<BiomeModifier> ctx) {
        MiscellaneousSettings miscellaneous = preset.miscellaneous();
        HolderGetter placedFeatures = ctx.m_255420_(Registries.f_256988_);
        HolderGetter biomes = ctx.m_255420_(Registries.f_256952_);
        HolderSet.Direct swamps = HolderSet.m_205809_((Holder[])new Holder[]{biomes.m_255043_(Biomes.f_48207_)});
        HolderSet.Direct plains = HolderSet.m_205809_((Holder[])new Holder[]{biomes.m_255043_(Biomes.f_48208_), biomes.m_255043_(Biomes.f_48202_), biomes.m_255043_(Biomes.f_48176_)});
        HolderSet.Direct forests = HolderSet.m_205809_((Holder[])new Holder[]{biomes.m_255043_(Biomes.f_48205_)});
        HolderSet.Direct flowerForests = HolderSet.m_205809_((Holder[])new Holder[]{biomes.m_255043_(Biomes.f_48205_), biomes.m_255043_(Biomes.f_48179_)});
        HolderSet.Direct birchForests = HolderSet.m_205809_((Holder[])new Holder[]{biomes.m_255043_(Biomes.f_48149_), biomes.m_255043_(Biomes.f_186762_)});
        HolderSet.Direct darkForests = HolderSet.m_205809_((Holder[])new Holder[]{biomes.m_255043_(Biomes.f_48151_)});
        HolderSet.Direct savannas = HolderSet.m_205809_((Holder[])new Holder[]{biomes.m_255043_(Biomes.f_48157_), biomes.m_255043_(Biomes.f_48158_)});
        HolderSet.Direct meadows = HolderSet.m_205809_((Holder[])new Holder[]{biomes.m_255043_(Biomes.f_186754_)});
        HolderSet.Direct firForests = HolderSet.m_205809_((Holder[])new Holder[]{biomes.m_255043_(Biomes.f_186755_), biomes.m_255043_(Biomes.f_186767_)});
        HolderSet.Direct windsweptHills = HolderSet.m_205809_((Holder[])new Holder[]{biomes.m_255043_(Biomes.f_186765_), biomes.m_255043_(Biomes.f_186766_)});
        HolderSet.Direct pineForests = HolderSet.m_205809_((Holder[])new Holder[]{biomes.m_255043_(Biomes.f_48206_), biomes.m_255043_(Biomes.f_186764_)});
        HolderSet.Direct spruceForests = HolderSet.m_205809_((Holder[])new Holder[]{biomes.m_255043_(Biomes.f_48152_)});
        HolderSet.Direct spruceTundras = HolderSet.m_205809_((Holder[])new Holder[]{biomes.m_255043_(Biomes.f_186761_)});
        HolderSet.Direct redwoodForests = HolderSet.m_205809_((Holder[])new Holder[]{biomes.m_255043_(Biomes.f_186763_)});
        HolderSet.Direct jungles = HolderSet.m_205809_((Holder[])new Holder[]{biomes.m_255043_(Biomes.f_48222_), biomes.m_255043_(Biomes.f_48197_)});
        HolderSet.Direct jungleEdges = HolderSet.m_205809_((Holder[])new Holder[]{biomes.m_255043_(Biomes.f_186769_)});
        HolderSet.Direct badlands = HolderSet.m_205809_((Holder[])new Holder[]{biomes.m_255043_(Biomes.f_186768_)});
        HolderSet.Direct woodedBadlands = HolderSet.m_205809_((Holder[])new Holder[]{biomes.m_255043_(Biomes.f_186753_)});
        HolderSet.Direct marshBushBiomes = HolderSet.m_205809_((Holder[])new Holder[0]);
        HolderSet.Direct plainsBushBiomes = HolderSet.m_205809_((Holder[])new Holder[]{biomes.m_255043_(Biomes.f_48149_), biomes.m_255043_(Biomes.f_186762_), biomes.m_255043_(Biomes.f_48202_), biomes.m_255043_(Biomes.f_48176_), biomes.m_255043_(Biomes.f_186765_), biomes.m_255043_(Biomes.f_186754_)});
        HolderSet.Direct steppeBushBiomes = HolderSet.m_205809_((Holder[])new Holder[]{biomes.m_255043_(Biomes.f_48157_), biomes.m_255043_(Biomes.f_186768_), biomes.m_255043_(Biomes.f_48158_)});
        HolderSet.Direct coldSteppeBiomes = HolderSet.m_205809_((Holder[])new Holder[0]);
        HolderSet.Direct taigaScrubBiomes = HolderSet.m_205809_((Holder[])new Holder[]{biomes.m_255043_(Biomes.f_186761_), biomes.m_255043_(Biomes.f_48206_), biomes.m_255043_(Biomes.f_186767_), biomes.m_255043_(Biomes.f_186766_)});
        HolderSet.Direct forestsWithGrass = HolderSet.m_205809_((Holder[])new Holder[]{biomes.m_255043_(Biomes.f_48205_), biomes.m_255043_(Biomes.f_48151_)});
        if (miscellaneous.customBiomeFeatures) {
            Holder.Reference plainsTrees = placedFeatures.m_255043_(PresetPlacedFeatures.PLAINS_TREES);
            Holder.Reference forestTrees = placedFeatures.m_255043_(PresetPlacedFeatures.FOREST_TREES);
            Holder.Reference flowerForestTrees = placedFeatures.m_255043_(PresetPlacedFeatures.FLOWER_FOREST_TREES);
            Holder.Reference birchTrees = placedFeatures.m_255043_(PresetPlacedFeatures.BIRCH_TREES);
            Holder.Reference darkForestTrees = placedFeatures.m_255043_(PresetPlacedFeatures.DARK_FOREST_TREES);
            Holder.Reference savannaTrees = placedFeatures.m_255043_(PresetPlacedFeatures.SAVANNA_TREES);
            Holder.Reference swampTrees = placedFeatures.m_255043_(PresetPlacedFeatures.SWAMP_TREES);
            Holder.Reference meadowTrees = placedFeatures.m_255043_(PresetPlacedFeatures.MEADOW_TREES);
            Holder.Reference firTrees = placedFeatures.m_255043_(PresetPlacedFeatures.FIR_TREES);
            Holder.Reference windsweptHillsFirTrees = placedFeatures.m_255043_(PresetPlacedFeatures.WINDSWEPT_HILLS_FIR_TREES);
            Holder.Reference pineTrees = placedFeatures.m_255043_(PresetPlacedFeatures.PINE_TREES);
            Holder.Reference spruceTrees = placedFeatures.m_255043_(PresetPlacedFeatures.SPRUCE_TREES);
            Holder.Reference spruceTundraTrees = placedFeatures.m_255043_(PresetPlacedFeatures.SPRUCE_TUNDRA_TREES);
            Holder.Reference redwoodTrees = placedFeatures.m_255043_(PresetPlacedFeatures.REDWOOD_TREES);
            Holder.Reference jungleTrees = placedFeatures.m_255043_(PresetPlacedFeatures.JUNGLE_TREES);
            Holder.Reference jungleEdgeTrees = placedFeatures.m_255043_(PresetPlacedFeatures.JUNGLE_EDGE_TREES);
            Holder.Reference badlandsTrees = placedFeatures.m_255043_(PresetPlacedFeatures.BADLANDS_TREES);
            Holder.Reference woodedBadlandsTrees = placedFeatures.m_255043_(PresetPlacedFeatures.WOODED_BADLANDS_TREES);
            ctx.m_255272_(REPLACE_PLAINS_TREES, (Object)BiomeModifiers.replace(GenerationStep.Decoration.VEGETAL_DECORATION, (HolderSet<Biome>)plains, Map.of(VegetationPlacements.f_195421_, plainsTrees)));
            ctx.m_255272_(REPLACE_FOREST_TREES, (Object)BiomeModifiers.replace(GenerationStep.Decoration.VEGETAL_DECORATION, (HolderSet<Biome>)forests, Map.of(VegetationPlacements.f_195440_, forestTrees)));
            ctx.m_255272_(REPLACE_FLOWER_FOREST_TREES, (Object)BiomeModifiers.replace(GenerationStep.Decoration.VEGETAL_DECORATION, (HolderSet<Biome>)flowerForests, Map.of(VegetationPlacements.f_195425_, flowerForestTrees)));
            ctx.m_255272_(REPLACE_BIRCH_TREES, (Object)BiomeModifiers.replace(GenerationStep.Decoration.VEGETAL_DECORATION, (HolderSet<Biome>)birchForests, Map.of(VegetationPlacements.f_195436_, birchTrees, VegetationPlacements.f_195435_, birchTrees)));
            ctx.m_255272_(REPLACE_DARK_FOREST_TREES, (Object)BiomeModifiers.replace(GenerationStep.Decoration.VEGETAL_DECORATION, (HolderSet<Biome>)darkForests, Map.of(VegetationPlacements.f_195422_, darkForestTrees)));
            ctx.m_255272_(REPLACE_SAVANNA_TREES, (Object)BiomeModifiers.replace(GenerationStep.Decoration.VEGETAL_DECORATION, (HolderSet<Biome>)savannas, Map.of(VegetationPlacements.f_195434_, savannaTrees)));
            ctx.m_255272_(REPLACE_SWAMP_TREES, (Object)BiomeModifiers.replace(GenerationStep.Decoration.VEGETAL_DECORATION, (HolderSet<Biome>)swamps, Map.of(VegetationPlacements.f_195432_, swampTrees)));
            ctx.m_255272_(REPLACE_MEADOW_TREES, (Object)BiomeModifiers.replace(GenerationStep.Decoration.VEGETAL_DECORATION, (HolderSet<Biome>)meadows, Map.of(VegetationPlacements.f_195427_, meadowTrees)));
            ctx.m_255272_(REPLACE_FIR_TREES, (Object)BiomeModifiers.replace(GenerationStep.Decoration.VEGETAL_DECORATION, (HolderSet<Biome>)firForests, Map.of(VegetationPlacements.f_195429_, firTrees, VegetationPlacements.f_195437_, firTrees)));
            ctx.m_255272_(REPLACE_WINDSWEPT_HILLS_FIR_TREES, (Object)BiomeModifiers.replace(GenerationStep.Decoration.VEGETAL_DECORATION, (HolderSet<Biome>)windsweptHills, Map.of(VegetationPlacements.f_195438_, windsweptHillsFirTrees)));
            ctx.m_255272_(REPLACE_PINE_TREES, (Object)BiomeModifiers.replace(GenerationStep.Decoration.VEGETAL_DECORATION, (HolderSet<Biome>)pineForests, Map.of(VegetationPlacements.f_195428_, pineTrees, VegetationPlacements.f_195442_, pineTrees)));
            ctx.m_255272_(REPLACE_SPRUCE_TREES, (Object)BiomeModifiers.replace(GenerationStep.Decoration.VEGETAL_DECORATION, (HolderSet<Biome>)spruceForests, Map.of(VegetationPlacements.f_195428_, spruceTrees)));
            ctx.m_255272_(REPLACE_SPRUCE_TUNDRA_TREES, (Object)BiomeModifiers.replace(GenerationStep.Decoration.VEGETAL_DECORATION, (HolderSet<Biome>)spruceTundras, Map.of(VegetationPlacements.f_195431_, spruceTundraTrees)));
            ctx.m_255272_(REPLACE_REDWOOD_TREES, (Object)BiomeModifiers.replace(GenerationStep.Decoration.VEGETAL_DECORATION, (HolderSet<Biome>)redwoodForests, Map.of(VegetationPlacements.f_195443_, redwoodTrees)));
            ctx.m_255272_(REPLACE_JUNGLE_TREES, (Object)BiomeModifiers.replace(GenerationStep.Decoration.VEGETAL_DECORATION, (HolderSet<Biome>)jungles, Map.of(VegetationPlacements.f_195444_, jungleTrees, VegetationPlacements.f_195445_, jungleTrees)));
            ctx.m_255272_(REPLACE_JUNGLE_EDGE_TREES, (Object)BiomeModifiers.replace(GenerationStep.Decoration.VEGETAL_DECORATION, (HolderSet<Biome>)jungleEdges, Map.of(VegetationPlacements.f_195441_, jungleEdgeTrees)));
            ctx.m_255272_(REPLACE_BADLANDS_TREES, (Object)BiomeModifiers.replace(GenerationStep.Decoration.VEGETAL_DECORATION, (HolderSet<Biome>)badlands, Map.of(VegetationPlacements.f_195430_, badlandsTrees, VegetationPlacements.f_195433_, badlandsTrees)));
            ctx.m_255272_(REPLACE_WOODED_BADLANDS_TREES, (Object)BiomeModifiers.replace(GenerationStep.Decoration.VEGETAL_DECORATION, (HolderSet<Biome>)woodedBadlands, Map.of(VegetationPlacements.f_195430_, woodedBadlandsTrees)));
            ctx.m_255272_(ADD_MARSH_BUSH, (Object)PresetBiomeModifierData.prepend(GenerationStep.Decoration.VEGETAL_DECORATION, Filter.Behavior.WHITELIST, (HolderSet<Biome>)marshBushBiomes, new Holder[]{placedFeatures.m_255043_(PresetPlacedFeatures.MARSH_BUSH)}));
            ctx.m_255272_(ADD_PLAINS_BUSH, (Object)PresetBiomeModifierData.prepend(GenerationStep.Decoration.VEGETAL_DECORATION, Filter.Behavior.WHITELIST, (HolderSet<Biome>)plainsBushBiomes, new Holder[]{placedFeatures.m_255043_(PresetPlacedFeatures.PLAINS_BUSH)}));
            ctx.m_255272_(ADD_STEPPE_BUSH, (Object)PresetBiomeModifierData.prepend(GenerationStep.Decoration.VEGETAL_DECORATION, Filter.Behavior.WHITELIST, (HolderSet<Biome>)steppeBushBiomes, new Holder[]{placedFeatures.m_255043_(PresetPlacedFeatures.STEPPE_BUSH)}));
            ctx.m_255272_(ADD_COLD_STEPPE_BUSH, (Object)PresetBiomeModifierData.prepend(GenerationStep.Decoration.VEGETAL_DECORATION, Filter.Behavior.WHITELIST, (HolderSet<Biome>)coldSteppeBiomes, new Holder[]{placedFeatures.m_255043_(PresetPlacedFeatures.COLD_STEPPE_BUSH)}));
            ctx.m_255272_(ADD_TAIGA_SCRUB_BUSH, (Object)PresetBiomeModifierData.prepend(GenerationStep.Decoration.VEGETAL_DECORATION, Filter.Behavior.WHITELIST, (HolderSet<Biome>)taigaScrubBiomes, new Holder[]{placedFeatures.m_255043_(PresetPlacedFeatures.TAIGA_SCRUB_BUSH)}));
            ctx.m_255272_(ADD_FOREST_GRASS, (Object)PresetBiomeModifierData.prepend(GenerationStep.Decoration.VEGETAL_DECORATION, Filter.Behavior.WHITELIST, (HolderSet<Biome>)forestsWithGrass, new Holder[]{placedFeatures.m_255043_(PresetPlacedFeatures.FOREST_GRASS)}));
            ctx.m_255272_(ADD_BIRCH_FOREST_GRASS, (Object)PresetBiomeModifierData.prepend(GenerationStep.Decoration.VEGETAL_DECORATION, Filter.Behavior.WHITELIST, (HolderSet<Biome>)birchForests, new Holder[]{placedFeatures.m_255043_(PresetPlacedFeatures.BIRCH_FOREST_GRASS)}));
        }
        if (miscellaneous.erosionDecorator) {
            ctx.m_255272_(ADD_EROSION, (Object)PresetBiomeModifierData.prepend(GenerationStep.Decoration.RAW_GENERATION, new Holder[]{placedFeatures.m_255043_(PresetPlacedFeatures.ERODE)}));
        }
        if (miscellaneous.naturalSnowDecorator || miscellaneous.smoothLayerDecorator) {
            ctx.m_255272_(ADD_SNOW_PROCESSING, (Object)PresetBiomeModifierData.append(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, new Holder[]{placedFeatures.m_255043_(PresetPlacedFeatures.DECORATE_SNOW)}));
        }
        ctx.m_255272_(ADD_SWAMP_SURFACE, (Object)PresetBiomeModifierData.prepend(GenerationStep.Decoration.RAW_GENERATION, Filter.Behavior.WHITELIST, (HolderSet<Biome>)swamps, new Holder[]{placedFeatures.m_255043_(PresetPlacedFeatures.SWAMP_SURFACE)}));
    }

    @SafeVarargs
    private static BiomeModifier prepend(GenerationStep.Decoration step, Holder<PlacedFeature> ... features) {
        return BiomeModifiers.add(Order.PREPEND, step, (HolderSet<PlacedFeature>)HolderSet.m_205809_(features));
    }

    @SafeVarargs
    private static BiomeModifier prepend(GenerationStep.Decoration step, Filter.Behavior filterBehavior, HolderSet<Biome> biomes, Holder<PlacedFeature> ... features) {
        return BiomeModifiers.add(Order.PREPEND, step, filterBehavior, biomes, (HolderSet<PlacedFeature>)HolderSet.m_205809_(features));
    }

    @SafeVarargs
    private static BiomeModifier append(GenerationStep.Decoration step, Holder<PlacedFeature> ... features) {
        return BiomeModifiers.add(Order.APPEND, step, (HolderSet<PlacedFeature>)HolderSet.m_205809_(features));
    }

    @SafeVarargs
    private static BiomeModifier append(GenerationStep.Decoration step, Filter.Behavior filterBehavior, HolderSet<Biome> biomes, Holder<PlacedFeature> ... features) {
        return BiomeModifiers.add(Order.APPEND, step, filterBehavior, biomes, (HolderSet<PlacedFeature>)HolderSet.m_205809_(features));
    }

    private static ResourceKey<BiomeModifier> createKey(String name) {
        return ResourceKey.m_135785_(RTFRegistries.BIOME_MODIFIER, (ResourceLocation)RTFCommon.location(name));
    }
}

