/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.data.worldgen.preset;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.MiscOverworldFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.TreePlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.DiskConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.RuleBasedBlockStateProvider;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import raccoonman.reterraforged.RTFCommon;
import raccoonman.reterraforged.data.worldgen.preset.PresetPlacedFeatures;
import raccoonman.reterraforged.data.worldgen.preset.PresetTemplatePaths;
import raccoonman.reterraforged.data.worldgen.preset.settings.MiscellaneousSettings;
import raccoonman.reterraforged.data.worldgen.preset.settings.Preset;
import raccoonman.reterraforged.data.worldgen.preset.settings.SurfaceSettings;
import raccoonman.reterraforged.world.worldgen.feature.BushFeature;
import raccoonman.reterraforged.world.worldgen.feature.DecorateSnowFeature;
import raccoonman.reterraforged.world.worldgen.feature.ErodeFeature;
import raccoonman.reterraforged.world.worldgen.feature.RTFFeatures;
import raccoonman.reterraforged.world.worldgen.feature.SwampSurfaceFeature;
import raccoonman.reterraforged.world.worldgen.feature.chance.ChanceFeature;
import raccoonman.reterraforged.world.worldgen.feature.chance.ChanceModifier;
import raccoonman.reterraforged.world.worldgen.feature.chance.RTFChanceModifiers;
import raccoonman.reterraforged.world.worldgen.feature.template.TemplateFeature;
import raccoonman.reterraforged.world.worldgen.feature.template.decorator.DecoratorConfig;
import raccoonman.reterraforged.world.worldgen.feature.template.decorator.TemplateDecorator;
import raccoonman.reterraforged.world.worldgen.feature.template.decorator.TreeContext;
import raccoonman.reterraforged.world.worldgen.feature.template.paste.PasteConfig;
import raccoonman.reterraforged.world.worldgen.feature.template.placement.TemplatePlacements;

public class PresetConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> ERODE = PresetConfiguredFeatures.createKey("erode");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DECORATE_SNOW = PresetConfiguredFeatures.createKey("decorate_snow");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SWAMP_SURFACE = PresetConfiguredFeatures.createKey("swamp_surface");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OAK_SMALL = PresetConfiguredFeatures.createKey("oak/small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OAK_FOREST = PresetConfiguredFeatures.createKey("oak/forest");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OAK_LARGE = PresetConfiguredFeatures.createKey("oak/large");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BIRCH_SMALL = PresetConfiguredFeatures.createKey("birch/small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BIRCH_FOREST = PresetConfiguredFeatures.createKey("birch/forest");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BIRCH_LARGE = PresetConfiguredFeatures.createKey("birch/large");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ACACIA_BUSH = PresetConfiguredFeatures.createKey("acacia/bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ACACIA_SMALL = PresetConfiguredFeatures.createKey("acacia/small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ACACIA_LARGE = PresetConfiguredFeatures.createKey("acacia/large");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DARK_OAK_SMALL = PresetConfiguredFeatures.createKey("dark_oak/small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DARK_OAK_LARGE = PresetConfiguredFeatures.createKey("dark_oak/large");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HUGE_BROWN_MUSHROOM = PresetConfiguredFeatures.createKey("mushrooms/huge_brown_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HUGE_RED_MUSHROOM = PresetConfiguredFeatures.createKey("mushrooms/huge_red_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILLOW_SMALL = PresetConfiguredFeatures.createKey("willow/small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILLOW_LARGE = PresetConfiguredFeatures.createKey("willow/large");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PINE = PresetConfiguredFeatures.createKey("pine");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPRUCE_SMALL = PresetConfiguredFeatures.createKey("spruce/small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPRUCE_LARGE = PresetConfiguredFeatures.createKey("spruce/large");
    public static final ResourceKey<ConfiguredFeature<?, ?>> REDWOOD_LARGE = PresetConfiguredFeatures.createKey("redwood/large");
    public static final ResourceKey<ConfiguredFeature<?, ?>> REDWOOD_HUGE = PresetConfiguredFeatures.createKey("redwood/huge");
    public static final ResourceKey<ConfiguredFeature<?, ?>> JUNGLE_SMALL = PresetConfiguredFeatures.createKey("jungle/small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> JUNGLE_LARGE = PresetConfiguredFeatures.createKey("jungle/large");
    public static final ResourceKey<ConfiguredFeature<?, ?>> JUNGLE_HUGE = PresetConfiguredFeatures.createKey("jungle/huge");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MARSH_BUSH = PresetConfiguredFeatures.createKey("shrubs/marsh_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PLAINS_BUSH = PresetConfiguredFeatures.createKey("shrubs/plains_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> STEPPE_BUSH = PresetConfiguredFeatures.createKey("shrubs/steppe_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> COLD_STEPPE_BUSH = PresetConfiguredFeatures.createKey("shrubs/cold_steppe_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TAIGA_SCRUB_BUSH = PresetConfiguredFeatures.createKey("shrubs/taiga_scrub_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FOREST_GRASS = PresetConfiguredFeatures.createKey("forest_grass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BIRCH_FOREST_GRASS = PresetConfiguredFeatures.createKey("birch_forest_grass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PLAINS_TREES = PresetConfiguredFeatures.createKey("plains_trees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FOREST_TREES = PresetConfiguredFeatures.createKey("forest_trees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FLOWER_FOREST_TREES = PresetConfiguredFeatures.createKey("flower_forest_trees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BIRCH_TREES = PresetConfiguredFeatures.createKey("birch_trees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DARK_FOREST_TREES = PresetConfiguredFeatures.createKey("dark_forest_trees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SAVANNA_TREES = PresetConfiguredFeatures.createKey("savanna_trees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BADLANDS_TREES = PresetConfiguredFeatures.createKey("badlands_trees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WOODED_BADLANDS_TREES = PresetConfiguredFeatures.createKey("wooded_badlands_trees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SWAMP_TREES = PresetConfiguredFeatures.createKey("swamp_trees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FIR_TREES = PresetConfiguredFeatures.createKey("fir_trees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPRUCE_TREES = PresetConfiguredFeatures.createKey("spruce_trees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPRUCE_TUNDRA_TREES = PresetConfiguredFeatures.createKey("spruce_tundra_trees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> REDWOOD_TREES = PresetConfiguredFeatures.createKey("redwood_trees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> JUNGLE_TREES = PresetConfiguredFeatures.createKey("jungle_trees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> JUNGLE_EDGE_TREES = PresetConfiguredFeatures.createKey("jungle_edge_trees");

    public static void bootstrap(Preset preset, BootstapContext<ConfiguredFeature<?, ?>> ctx) {
        MiscellaneousSettings miscellaneous = preset.miscellaneous();
        SurfaceSettings surface = preset.surface();
        SurfaceSettings.Erosion erosion = surface.erosion();
        ErodeFeature.Config erodeConfig = new ErodeFeature.Config(erosion.rockVariance, erosion.rockMin, erosion.dirtVariance, erosion.dirtMin, erosion.rockSteepness, erosion.dirtSteepness, erosion.screeSteepness, 0.023529412f, 0.011764706f, 256.0f, 0.011764706f, 0.55f);
        if (miscellaneous.erosionDecorator) {
            FeatureUtils.m_254977_(ctx, ERODE, RTFFeatures.ERODE, (FeatureConfiguration)erodeConfig);
        }
        if (miscellaneous.naturalSnowDecorator || miscellaneous.smoothLayerDecorator) {
            FeatureUtils.m_254977_(ctx, DECORATE_SNOW, RTFFeatures.DECORATE_SNOW, (FeatureConfiguration)new DecorateSnowFeature.Config(miscellaneous.naturalSnowDecorator, miscellaneous.smoothLayerDecorator, erodeConfig));
        }
        FeatureUtils.m_254977_(ctx, SWAMP_SURFACE, RTFFeatures.SWAMP_SURFACE, (FeatureConfiguration)new SwampSurfaceFeature.Config(Blocks.f_50129_.m_49966_(), Blocks.f_49994_.m_49966_(), Blocks.f_50493_.m_49966_()));
        if (miscellaneous.customBiomeFeatures) {
            HolderGetter placedFeatures = ctx.m_255420_(Registries.f_256988_);
            Holder.Reference oakSmall = placedFeatures.m_255043_(PresetPlacedFeatures.OAK_SMALL);
            Holder.Reference oakForest = placedFeatures.m_255043_(PresetPlacedFeatures.OAK_FOREST);
            Holder.Reference oakLarge = placedFeatures.m_255043_(PresetPlacedFeatures.OAK_LARGE);
            Holder.Reference birchSmall = placedFeatures.m_255043_(PresetPlacedFeatures.BIRCH_SMALL);
            Holder.Reference birchForest = placedFeatures.m_255043_(PresetPlacedFeatures.BIRCH_FOREST);
            Holder.Reference birchLarge = placedFeatures.m_255043_(PresetPlacedFeatures.BIRCH_LARGE);
            Holder.Reference acaciaBush = placedFeatures.m_255043_(PresetPlacedFeatures.ACACIA_BUSH);
            Holder.Reference acaciaSmall = placedFeatures.m_255043_(PresetPlacedFeatures.ACACIA_SMALL);
            Holder.Reference acaciaLarge = placedFeatures.m_255043_(PresetPlacedFeatures.ACACIA_LARGE);
            Holder.Reference darkOakSmall = placedFeatures.m_255043_(PresetPlacedFeatures.DARK_OAK_SMALL);
            Holder.Reference darkOakLarge = placedFeatures.m_255043_(PresetPlacedFeatures.DARK_OAK_LARGE);
            Holder.Reference hugeBrownMushroom = placedFeatures.m_255043_(PresetPlacedFeatures.HUGE_BROWN_MUSHROOM);
            Holder.Reference hugeRedMushroom = placedFeatures.m_255043_(PresetPlacedFeatures.HUGE_RED_MUSHROOM);
            Holder.Reference willowSmall = placedFeatures.m_255043_(PresetPlacedFeatures.WILLOW_SMALL);
            Holder.Reference willowLarge = placedFeatures.m_255043_(PresetPlacedFeatures.WILLOW_LARGE);
            Holder.Reference spruceSmall = placedFeatures.m_255043_(PresetPlacedFeatures.SPRUCE_SMALL);
            Holder.Reference spruceLarge = placedFeatures.m_255043_(PresetPlacedFeatures.SPRUCE_LARGE);
            Holder.Reference redwoodLarge = placedFeatures.m_255043_(PresetPlacedFeatures.REDWOOD_LARGE);
            Holder.Reference redwoodHuge = placedFeatures.m_255043_(PresetPlacedFeatures.REDWOOD_HUGE);
            Holder.Reference jungleSmall = placedFeatures.m_255043_(PresetPlacedFeatures.JUNGLE_SMALL);
            Holder.Reference jungleLarge = placedFeatures.m_255043_(PresetPlacedFeatures.JUNGLE_LARGE);
            Holder.Reference jungleHuge = placedFeatures.m_255043_(PresetPlacedFeatures.JUNGLE_HUGE);
            Holder.Reference jungleBush = placedFeatures.m_255043_(TreePlacements.f_195389_);
            FeatureUtils.m_254977_(ctx, OAK_SMALL, RTFFeatures.TEMPLATE, PresetConfiguredFeatures.makeTree(PresetTemplatePaths.OAK_SMALL));
            FeatureUtils.m_254977_(ctx, OAK_FOREST, RTFFeatures.TEMPLATE, PresetConfiguredFeatures.makeTree(PresetTemplatePaths.OAK_FOREST));
            FeatureUtils.m_254977_(ctx, OAK_LARGE, RTFFeatures.TEMPLATE, PresetConfiguredFeatures.makeTree(PresetTemplatePaths.OAK_LARGE));
            FeatureUtils.m_254977_(ctx, BIRCH_SMALL, RTFFeatures.TEMPLATE, PresetConfiguredFeatures.makeTree(PresetTemplatePaths.BIRCH_SMALL));
            FeatureUtils.m_254977_(ctx, BIRCH_FOREST, RTFFeatures.TEMPLATE, PresetConfiguredFeatures.makeTree(PresetTemplatePaths.BIRCH_FOREST));
            FeatureUtils.m_254977_(ctx, BIRCH_LARGE, RTFFeatures.TEMPLATE, PresetConfiguredFeatures.makeTree(PresetTemplatePaths.BIRCH_LARGE));
            FeatureUtils.m_254977_(ctx, ACACIA_BUSH, RTFFeatures.TEMPLATE, PresetConfiguredFeatures.makeTree(PresetTemplatePaths.ACACIA_BUSH, 2));
            FeatureUtils.m_254977_(ctx, ACACIA_SMALL, RTFFeatures.TEMPLATE, PresetConfiguredFeatures.makeTree(PresetTemplatePaths.ACACIA_SMALL));
            FeatureUtils.m_254977_(ctx, ACACIA_LARGE, RTFFeatures.TEMPLATE, PresetConfiguredFeatures.makeTree(PresetTemplatePaths.ACACIA_LARGE));
            FeatureUtils.m_254977_(ctx, DARK_OAK_SMALL, RTFFeatures.TEMPLATE, PresetConfiguredFeatures.makeTree(PresetTemplatePaths.DARK_OAK_SMALL));
            FeatureUtils.m_254977_(ctx, DARK_OAK_LARGE, RTFFeatures.TEMPLATE, PresetConfiguredFeatures.makeTree(PresetTemplatePaths.DARK_OAK_LARGE));
            FeatureUtils.m_254977_(ctx, HUGE_BROWN_MUSHROOM, RTFFeatures.TEMPLATE, PresetConfiguredFeatures.makeTree(PresetTemplatePaths.BROWN_MUSHROOM, 0));
            FeatureUtils.m_254977_(ctx, HUGE_RED_MUSHROOM, RTFFeatures.TEMPLATE, PresetConfiguredFeatures.makeTree(PresetTemplatePaths.RED_MUSHROOM));
            FeatureUtils.m_254977_(ctx, WILLOW_SMALL, RTFFeatures.TEMPLATE, PresetConfiguredFeatures.makeTree(PresetTemplatePaths.WILLOW_SMALL));
            FeatureUtils.m_254977_(ctx, WILLOW_LARGE, RTFFeatures.TEMPLATE, PresetConfiguredFeatures.makeTree(PresetTemplatePaths.WILLOW_LARGE));
            FeatureUtils.m_254977_(ctx, PINE, RTFFeatures.TEMPLATE, PresetConfiguredFeatures.makeTree(PresetTemplatePaths.PINE));
            FeatureUtils.m_254977_(ctx, SPRUCE_SMALL, RTFFeatures.TEMPLATE, PresetConfiguredFeatures.makeTree(PresetTemplatePaths.SPRUCE_SMALL));
            FeatureUtils.m_254977_(ctx, SPRUCE_LARGE, RTFFeatures.TEMPLATE, PresetConfiguredFeatures.makeTree(PresetTemplatePaths.SPRUCE_LARGE));
            FeatureUtils.m_254977_(ctx, REDWOOD_LARGE, RTFFeatures.TEMPLATE, PresetConfiguredFeatures.makeTree(PresetTemplatePaths.REDWOOD_LARGE));
            FeatureUtils.m_254977_(ctx, REDWOOD_HUGE, RTFFeatures.TEMPLATE, PresetConfiguredFeatures.makeTree(PresetTemplatePaths.REDWOOD_HUGE));
            FeatureUtils.m_254977_(ctx, JUNGLE_SMALL, RTFFeatures.TEMPLATE, PresetConfiguredFeatures.makeTree(PresetTemplatePaths.JUNGLE_SMALL));
            FeatureUtils.m_254977_(ctx, JUNGLE_LARGE, RTFFeatures.TEMPLATE, PresetConfiguredFeatures.makeTree(PresetTemplatePaths.JUNGLE_LARGE));
            FeatureUtils.m_254977_(ctx, JUNGLE_HUGE, RTFFeatures.TEMPLATE, PresetConfiguredFeatures.makeTree(PresetTemplatePaths.JUNGLE_HUGE));
            FeatureUtils.m_254977_(ctx, MARSH_BUSH, RTFFeatures.BUSH, (FeatureConfiguration)PresetConfiguredFeatures.makeSmallBush(Blocks.f_49999_, Blocks.f_50052_, 0.05f, 0.09f, 0.65f));
            FeatureUtils.m_254977_(ctx, PLAINS_BUSH, RTFFeatures.BUSH, (FeatureConfiguration)PresetConfiguredFeatures.makeSmallBush(Blocks.f_49999_, Blocks.f_50052_, 0.05f, 0.09f, 0.65f));
            FeatureUtils.m_254977_(ctx, STEPPE_BUSH, RTFFeatures.BUSH, (FeatureConfiguration)PresetConfiguredFeatures.makeSmallBush(Blocks.f_50003_, Blocks.f_50054_, 0.06f, 0.08f, 0.7f));
            FeatureUtils.m_254977_(ctx, COLD_STEPPE_BUSH, RTFFeatures.BUSH, (FeatureConfiguration)PresetConfiguredFeatures.makeSmallBush(Blocks.f_50000_, Blocks.f_50050_, 0.05f, 0.075f, 0.6f));
            FeatureUtils.m_254977_(ctx, TAIGA_SCRUB_BUSH, RTFFeatures.BUSH, (FeatureConfiguration)PresetConfiguredFeatures.makeSmallBush(Blocks.f_50000_, Blocks.f_50051_, 0.05f, 0.075f, 0.6f));
            FeatureUtils.m_254977_(ctx, PLAINS_TREES, (Feature)Feature.f_65754_, (FeatureConfiguration)PresetConfiguredFeatures.makeRandom((Holder<PlacedFeature>)oakForest, List.of(PresetConfiguredFeatures.makeWeighted(0.2f, (Holder<PlacedFeature>)oakForest), PresetConfiguredFeatures.makeWeighted(0.3f, (Holder<PlacedFeature>)oakLarge))));
            FeatureUtils.m_254977_(ctx, FOREST_TREES, (Feature)Feature.f_65754_, (FeatureConfiguration)PresetConfiguredFeatures.makeRandom((Holder<PlacedFeature>)oakForest, List.of(PresetConfiguredFeatures.makeWeighted(0.2f, (Holder<PlacedFeature>)oakForest), PresetConfiguredFeatures.makeWeighted(0.3f, (Holder<PlacedFeature>)oakLarge))));
            FeatureUtils.m_254977_(ctx, FLOWER_FOREST_TREES, (Feature)Feature.f_65754_, (FeatureConfiguration)PresetConfiguredFeatures.makeRandom((Holder<PlacedFeature>)birchForest, List.of(PresetConfiguredFeatures.makeWeighted(0.2f, (Holder<PlacedFeature>)birchForest), PresetConfiguredFeatures.makeWeighted(0.2f, (Holder<PlacedFeature>)birchLarge), PresetConfiguredFeatures.makeWeighted(0.2f, (Holder<PlacedFeature>)oakForest), PresetConfiguredFeatures.makeWeighted(0.2f, (Holder<PlacedFeature>)oakLarge))));
            FeatureUtils.m_254977_(ctx, BIRCH_TREES, RTFFeatures.CHANCE, (FeatureConfiguration)PresetConfiguredFeatures.makeChance(PresetConfiguredFeatures.makeChanceEntry((Holder<PlacedFeature>)birchLarge, 0.2f, RTFChanceModifiers.elevation(0.25f, 0.0f), RTFChanceModifiers.biomeEdge(0.1f, 0.3f)), PresetConfiguredFeatures.makeChanceEntry((Holder<PlacedFeature>)birchForest, 0.2f, RTFChanceModifiers.elevation(0.3f, 0.0f), RTFChanceModifiers.biomeEdge(0.05f, 0.2f)), PresetConfiguredFeatures.makeChanceEntry((Holder<PlacedFeature>)birchSmall, 0.1f, RTFChanceModifiers.biomeEdge(0.25f, 0.0f)), PresetConfiguredFeatures.makeChanceEntry((Holder<PlacedFeature>)birchSmall, 0.1f, RTFChanceModifiers.elevation(0.25f, 0.65f))));
            FeatureUtils.m_254977_(ctx, DARK_FOREST_TREES, (Feature)Feature.f_65754_, (FeatureConfiguration)PresetConfiguredFeatures.makeRandom((Holder<PlacedFeature>)darkOakLarge, List.of(PresetConfiguredFeatures.makeWeighted(0.025f, (Holder<PlacedFeature>)hugeBrownMushroom), PresetConfiguredFeatures.makeWeighted(0.05f, (Holder<PlacedFeature>)hugeRedMushroom), PresetConfiguredFeatures.makeWeighted(0.3f, (Holder<PlacedFeature>)darkOakLarge), PresetConfiguredFeatures.makeWeighted(0.2f, (Holder<PlacedFeature>)darkOakSmall), PresetConfiguredFeatures.makeWeighted(0.05f, (Holder<PlacedFeature>)birchForest), PresetConfiguredFeatures.makeWeighted(0.025f, (Holder<PlacedFeature>)oakForest))));
            FeatureUtils.m_254977_(ctx, SAVANNA_TREES, (Feature)Feature.f_65754_, (FeatureConfiguration)PresetConfiguredFeatures.makeRandom((Holder<PlacedFeature>)acaciaLarge, List.of(PresetConfiguredFeatures.makeWeighted(0.4f, (Holder<PlacedFeature>)acaciaLarge), PresetConfiguredFeatures.makeWeighted(0.15f, (Holder<PlacedFeature>)acaciaSmall))));
            FeatureUtils.m_254977_(ctx, BADLANDS_TREES, (Feature)Feature.f_65754_, (FeatureConfiguration)PresetConfiguredFeatures.makeRandom((Holder<PlacedFeature>)oakSmall, List.of(PresetConfiguredFeatures.makeWeighted(0.2f, (Holder<PlacedFeature>)oakSmall), PresetConfiguredFeatures.makeWeighted(0.1f, (Holder<PlacedFeature>)acaciaBush))));
            FeatureUtils.m_254977_(ctx, WOODED_BADLANDS_TREES, (Feature)Feature.f_65754_, (FeatureConfiguration)PresetConfiguredFeatures.makeRandom((Holder<PlacedFeature>)oakSmall, List.of(PresetConfiguredFeatures.makeWeighted(0.3f, (Holder<PlacedFeature>)oakSmall), PresetConfiguredFeatures.makeWeighted(0.2f, (Holder<PlacedFeature>)acaciaBush))));
            FeatureUtils.m_254977_(ctx, SWAMP_TREES, (Feature)Feature.f_65754_, (FeatureConfiguration)PresetConfiguredFeatures.makeRandom((Holder<PlacedFeature>)willowLarge, List.of(PresetConfiguredFeatures.makeWeighted(0.2f, (Holder<PlacedFeature>)willowSmall), PresetConfiguredFeatures.makeWeighted(0.35f, (Holder<PlacedFeature>)willowLarge))));
            FeatureUtils.m_254977_(ctx, FIR_TREES, RTFFeatures.CHANCE, (FeatureConfiguration)PresetConfiguredFeatures.makeChance(PresetConfiguredFeatures.makeChanceEntry((Holder<PlacedFeature>)spruceSmall, 0.1f, RTFChanceModifiers.elevation(0.55f, 0.2f)), PresetConfiguredFeatures.makeChanceEntry((Holder<PlacedFeature>)spruceLarge, 0.25f, RTFChanceModifiers.elevation(0.3f, 0.0f))));
            FeatureUtils.m_254977_(ctx, REDWOOD_TREES, RTFFeatures.CHANCE, (FeatureConfiguration)PresetConfiguredFeatures.makeChance(PresetConfiguredFeatures.makeChanceEntry((Holder<PlacedFeature>)redwoodHuge, 0.4f, RTFChanceModifiers.elevation(0.15f, 0.0f), RTFChanceModifiers.biomeEdge(0.1f, 0.3f)), PresetConfiguredFeatures.makeChanceEntry((Holder<PlacedFeature>)redwoodLarge, 0.2f, RTFChanceModifiers.elevation(0.25f, 0.0f), RTFChanceModifiers.biomeEdge(0.05f, 0.25f)), PresetConfiguredFeatures.makeChanceEntry((Holder<PlacedFeature>)spruceLarge, 0.4f, RTFChanceModifiers.elevation(0.35f, 0.15f)), PresetConfiguredFeatures.makeChanceEntry((Holder<PlacedFeature>)spruceSmall, 0.2f, RTFChanceModifiers.elevation(0.5f, 0.2f))));
            FeatureUtils.m_254977_(ctx, JUNGLE_TREES, (Feature)Feature.f_65754_, (FeatureConfiguration)PresetConfiguredFeatures.makeRandom((Holder<PlacedFeature>)jungleSmall, List.of(PresetConfiguredFeatures.makeWeighted(0.2f, (Holder<PlacedFeature>)jungleSmall), PresetConfiguredFeatures.makeWeighted(0.3f, (Holder<PlacedFeature>)jungleLarge), PresetConfiguredFeatures.makeWeighted(0.4f, (Holder<PlacedFeature>)jungleHuge), PresetConfiguredFeatures.makeWeighted(0.5f, (Holder<PlacedFeature>)jungleBush))));
            FeatureUtils.m_254977_(ctx, JUNGLE_EDGE_TREES, (Feature)Feature.f_65754_, (FeatureConfiguration)PresetConfiguredFeatures.makeRandom((Holder<PlacedFeature>)jungleSmall, List.of(PresetConfiguredFeatures.makeWeighted(0.2f, (Holder<PlacedFeature>)jungleSmall), PresetConfiguredFeatures.makeWeighted(0.3f, (Holder<PlacedFeature>)jungleLarge), PresetConfiguredFeatures.makeWeighted(0.4f, (Holder<PlacedFeature>)jungleBush))));
            FeatureUtils.m_254977_(ctx, FOREST_GRASS, (Feature)Feature.f_65754_, (FeatureConfiguration)PresetConfiguredFeatures.makeRandom(PresetConfiguredFeatures.makeInlined(Feature.f_65763_, PresetConfiguredFeatures.makePatch(Blocks.f_50034_, 48)), List.of(PresetConfiguredFeatures.makeWeighted(0.5f, PresetConfiguredFeatures.makeInlined(Feature.f_65763_, PresetConfiguredFeatures.makePatch(Blocks.f_50034_, 56))), PresetConfiguredFeatures.makeWeighted(0.4f, PresetConfiguredFeatures.makeInlined(Feature.f_65763_, PresetConfiguredFeatures.makePatch(Blocks.f_50359_, 56))), PresetConfiguredFeatures.makeWeighted(0.2f, PresetConfiguredFeatures.makeInlined(Feature.f_65763_, PresetConfiguredFeatures.makePatch(Blocks.f_50360_, 48))), PresetConfiguredFeatures.makeWeighted(0.2f, PresetConfiguredFeatures.makeInlined(Feature.f_65763_, PresetConfiguredFeatures.makePatch(Blocks.f_50035_, 24))))));
            FeatureUtils.m_254977_(ctx, BIRCH_FOREST_GRASS, (Feature)Feature.f_65754_, (FeatureConfiguration)PresetConfiguredFeatures.makeRandom(PresetConfiguredFeatures.makeInlined(Feature.f_65763_, PresetConfiguredFeatures.makePatch(Blocks.f_50359_, 48)), List.of(PresetConfiguredFeatures.makeWeighted(0.8f, PresetConfiguredFeatures.makeInlined(Feature.f_65763_, PresetConfiguredFeatures.makePatch(Blocks.f_50359_, 56))), PresetConfiguredFeatures.makeWeighted(0.5f, PresetConfiguredFeatures.makeInlined(Feature.f_65763_, PresetConfiguredFeatures.makePatch(Blocks.f_50356_, 64))), PresetConfiguredFeatures.makeWeighted(0.3f, PresetConfiguredFeatures.makeInlined(Feature.f_65763_, PresetConfiguredFeatures.makePatch(Blocks.f_50360_, 48))), PresetConfiguredFeatures.makeWeighted(0.2f, PresetConfiguredFeatures.makeInlined(Feature.f_65763_, PresetConfiguredFeatures.makePatch(Blocks.f_50035_, 24))), PresetConfiguredFeatures.makeWeighted(0.1f, PresetConfiguredFeatures.makeInlined(Feature.f_65763_, PresetConfiguredFeatures.makePatch(Blocks.f_50358_, 32))))));
            FeatureUtils.m_254977_(ctx, (ResourceKey)MiscOverworldFeatures.f_195017_, RTFFeatures.DISK, (FeatureConfiguration)new DiskConfiguration(RuleBasedBlockStateProvider.m_225936_((Block)Blocks.f_50129_), BlockPredicate.m_198311_(List.of(Blocks.f_50493_, Blocks.f_50129_)), (IntProvider)UniformInt.m_146622_((int)2, (int)3), 1));
            FeatureUtils.m_254977_(ctx, (ResourceKey)MiscOverworldFeatures.f_195018_, RTFFeatures.DISK, (FeatureConfiguration)new DiskConfiguration(RuleBasedBlockStateProvider.m_225936_((Block)Blocks.f_49994_), BlockPredicate.m_198311_(List.of(Blocks.f_50493_, Blocks.f_50440_)), (IntProvider)UniformInt.m_146622_((int)2, (int)5), 2));
            FeatureUtils.m_254977_(ctx, (ResourceKey)MiscOverworldFeatures.f_195019_, RTFFeatures.DISK, (FeatureConfiguration)new DiskConfiguration(new RuleBasedBlockStateProvider((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_49992_), List.of(new RuleBasedBlockStateProvider.Rule(BlockPredicate.m_224774_((Vec3i)Direction.DOWN.m_122436_(), (Block[])new Block[]{Blocks.f_50016_}), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50062_)))), BlockPredicate.m_198311_(List.of(Blocks.f_50493_, Blocks.f_50440_)), (IntProvider)UniformInt.m_146622_((int)2, (int)6), 2));
        }
    }

    private static BushFeature.Config makeSmallBush(Block log, Block leaves, float air, float leaf, float size) {
        return new BushFeature.Config(log.m_49966_(), leaves.m_49966_(), air, leaf, size);
    }

    private static TemplateFeature.Config<?> makeTree(List<ResourceLocation> templates) {
        return PresetConfiguredFeatures.makeTree(templates, 3);
    }

    private static TemplateFeature.Config<?> makeTree(List<ResourceLocation> templates, int baseExtension) {
        return PresetConfiguredFeatures.makeTree(templates, (List<TemplateDecorator<TreeContext>>)ImmutableList.of(), baseExtension);
    }

    private static TemplateFeature.Config<?> makeTree(List<ResourceLocation> templates, List<TemplateDecorator<TreeContext>> decorators, int baseExtension) {
        return new TemplateFeature.Config<TreeContext>(templates, TemplatePlacements.tree(), new PasteConfig(baseExtension, false, true, false, false), new DecoratorConfig(decorators, ImmutableMap.of()));
    }

    private static ChanceFeature.Config makeChance(ChanceFeature.Entry ... entries) {
        return new ChanceFeature.Config((List<ChanceFeature.Entry>)ImmutableList.copyOf((Object[])entries));
    }

    private static ChanceFeature.Entry makeChanceEntry(Holder<PlacedFeature> feature, float chance, ChanceModifier ... modifiers) {
        return new ChanceFeature.Entry(feature, chance, (List<ChanceModifier>)ImmutableList.copyOf((Object[])modifiers));
    }

    private static RandomFeatureConfiguration makeRandom(Holder<PlacedFeature> defaultFeature, List<WeightedPlacedFeature> entries) {
        return new RandomFeatureConfiguration(entries, defaultFeature);
    }

    private static WeightedPlacedFeature makeWeighted(float weight, Holder<PlacedFeature> feature) {
        return new WeightedPlacedFeature(feature, weight);
    }

    private static RandomPatchConfiguration makePatch(Block state, int tries) {
        return FeatureUtils.m_206470_((int)tries, (Holder)PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)state.m_49966_()))));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> Holder<PlacedFeature> makeInlined(F feature, FC featureConfiguration) {
        return Holder.m_205709_((Object)new PlacedFeature(Holder.m_205709_((Object)new ConfiguredFeature(feature, featureConfiguration)), (List)ImmutableList.of()));
    }

    protected static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)RTFCommon.location(name));
    }
}

