/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.data.worldgen.preset;

import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.OreVeinifier;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import raccoonman.reterraforged.RTFCommon;
import raccoonman.reterraforged.data.worldgen.preset.settings.CaveSettings;
import raccoonman.reterraforged.data.worldgen.preset.settings.Preset;
import raccoonman.reterraforged.data.worldgen.preset.settings.WorldSettings;
import raccoonman.reterraforged.world.worldgen.densityfunction.CellSampler;
import raccoonman.reterraforged.world.worldgen.densityfunction.RTFDensityFunctions;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;

public class PresetNoiseRouterData {
    public static final ResourceKey<DensityFunction> HEIGHT = PresetNoiseRouterData.createKey("height");
    public static final ResourceKey<DensityFunction> GRADIENT = PresetNoiseRouterData.createKey("gradient");
    public static final ResourceKey<DensityFunction> HEIGHT_EROSION = PresetNoiseRouterData.createKey("erosion");
    public static final ResourceKey<DensityFunction> SEDIMENT = PresetNoiseRouterData.createKey("sediment");
    private static final float SCALER = 128.0f;
    private static final float UNIT = 0.0078125f;

    public static void bootstrap(Preset preset, BootstapContext<DensityFunction> ctx) {
        HolderGetter densityFunctions = ctx.m_255420_(Registries.f_257040_);
        HolderGetter noiseParams = ctx.m_255420_(Registries.f_256865_);
        WorldSettings worldSettings = preset.world();
        WorldSettings.Properties properties = worldSettings.properties;
        CaveSettings caveSettings = preset.caves();
        int worldHeight = properties.worldHeight;
        int worldDepth = properties.worldDepth;
        ctx.m_255272_(NoiseRouterData.f_209451_, (Object)RTFDensityFunctions.cell(CellSampler.Field.CONTINENT));
        ctx.m_255272_(NoiseRouterData.f_209452_, (Object)RTFDensityFunctions.cell(CellSampler.Field.EROSION));
        ctx.m_255272_(NoiseRouterData.f_209453_, (Object)RTFDensityFunctions.cell(CellSampler.Field.WEIRDNESS));
        DensityFunction height = NoiseRouterData.m_255105_(ctx, HEIGHT, (DensityFunction)RTFDensityFunctions.cell(CellSampler.Field.HEIGHT));
        DensityFunction offset = NoiseRouterData.m_255105_(ctx, (ResourceKey)NoiseRouterData.f_224430_, (DensityFunction)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)-1.0037500858306885), (DensityFunction)DensityFunctions.m_208363_((DensityFunction)RTFDensityFunctions.clampToNearestUnit(height, properties.terrainScaler()), (DensityFunction)DensityFunctions.m_208264_((double)2.0))));
        ctx.m_255272_(NoiseRouterData.f_209455_, (Object)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208266_((int)(-worldDepth), (int)worldHeight, (double)PresetNoiseRouterData.yGradientRange(-worldDepth), (double)PresetNoiseRouterData.yGradientRange(worldHeight)), (DensityFunction)offset));
        ctx.m_255272_(NoiseRouterData.f_224433_, (Object)DensityFunctions.m_208263_());
        ctx.m_255272_(NoiseRouterData.f_224431_, (Object)PresetNoiseRouterData.jaggednessPerformanceHack());
        ctx.m_255272_(NoiseRouterData.f_209465_, (Object)PresetNoiseRouterData.noodle(-worldDepth, worldHeight, 1.0f - caveSettings.noodleCaveProbability, (HolderGetter<DensityFunction>)densityFunctions, (HolderGetter<NormalNoise.NoiseParameters>)noiseParams));
        ctx.m_255272_(NoiseRouterData.f_209464_, (Object)PresetNoiseRouterData.probabilityDensity(caveSettings.entranceCaveProbability, NoiseRouterData.m_255275_((HolderGetter)densityFunctions, (HolderGetter)noiseParams)));
        ctx.m_255272_(NoiseRouterData.f_209439_, (Object)PresetNoiseRouterData.probabilityDensity(caveSettings.spaghettiCaveProbability, PresetNoiseRouterData.spaghetti2D(-worldDepth, worldHeight, (HolderGetter<DensityFunction>)densityFunctions, (HolderGetter<NormalNoise.NoiseParameters>)noiseParams)));
        ctx.m_255272_(GRADIENT, (Object)RTFDensityFunctions.cell(CellSampler.Field.GRADIENT));
        ctx.m_255272_(HEIGHT_EROSION, (Object)RTFDensityFunctions.cell(CellSampler.Field.HEIGHT_EROSION));
        ctx.m_255272_(SEDIMENT, (Object)RTFDensityFunctions.cell(CellSampler.Field.SEDIMENT));
    }

    protected static NoiseRouter overworld(Preset preset, HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParams, HolderGetter<Noise> noises) {
        WorldSettings worldSettings = preset.world();
        WorldSettings.Properties properties = worldSettings.properties;
        int worldDepth = properties.worldDepth;
        CaveSettings caves = preset.caves();
        float cheeseCaveDepthOffset = caves.cheeseCaveDepthOffset;
        DensityFunction aquiferBarrier = DensityFunctions.m_208324_((Holder)noiseParams.m_255043_(Noises.f_189287_), (double)0.5);
        DensityFunction aquiferFluidLevelFloodedness = DensityFunctions.m_208324_((Holder)noiseParams.m_255043_(Noises.f_189288_), (double)0.67);
        DensityFunction aquiferFluidLevelSpread = DensityFunctions.m_208324_((Holder)noiseParams.m_255043_(Noises.f_189290_), (double)0.7142857142857143);
        DensityFunction aquiferLava = DensityFunctions.m_208322_((Holder)noiseParams.m_255043_(Noises.f_189289_));
        CellSampler.Marker temperature = RTFDensityFunctions.cell(CellSampler.Field.TEMPERATURE);
        CellSampler.Marker vegetation = RTFDensityFunctions.cell(CellSampler.Field.MOISTURE);
        DensityFunction factor = NoiseRouterData.m_255403_(densityFunctions, (ResourceKey)NoiseRouterData.f_209454_);
        DensityFunction depth = NoiseRouterData.m_255403_(densityFunctions, (ResourceKey)NoiseRouterData.f_209455_);
        DensityFunction initialDensity = NoiseRouterData.m_212271_((DensityFunction)DensityFunctions.m_208373_((DensityFunction)factor), (DensityFunction)depth);
        DensityFunction slopedCheese = NoiseRouterData.m_255403_(densityFunctions, (ResourceKey)NoiseRouterData.f_209456_);
        DensityFunction entrances = caves.entranceCaveProbability > 0.0f ? DensityFunctions.m_208375_((DensityFunction)slopedCheese, (DensityFunction)DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)5.0), (DensityFunction)DensityFunctions.m_208281_((DensityFunction)NoiseRouterData.m_255403_(densityFunctions, (ResourceKey)NoiseRouterData.f_209464_)))) : slopedCheese;
        DensityFunction slopedCheeseRange = DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208287_((DensityFunction)slopedCheese, (double)-1000000.0, (double)cheeseCaveDepthOffset, (DensityFunction)entrances, (DensityFunction)DensityFunctions.m_208281_((DensityFunction)PresetNoiseRouterData.slideOverworld(PresetNoiseRouterData.underground(caves.cheeseCaveProbability, densityFunctions, noiseParams, slopedCheese), -worldDepth))), (DensityFunction)DensityFunctions.m_208264_((double)0.64)).m_208234_();
        DensityFunction finalDensity = DensityFunctions.m_208375_((DensityFunction)slopedCheeseRange, (DensityFunction)NoiseRouterData.m_255403_(densityFunctions, (ResourceKey)NoiseRouterData.f_209465_));
        DensityFunction y = NoiseRouterData.m_255403_(densityFunctions, (ResourceKey)NoiseRouterData.f_209447_);
        int minY = Stream.of(OreVeinifier.VeinType.values()).mapToInt(veinType -> veinType.f_209674_).min().orElse(-DimensionType.f_156653_ * 2);
        int maxY = Stream.of(OreVeinifier.VeinType.values()).mapToInt(veinType -> veinType.f_209675_).max().orElse(-DimensionType.f_156653_ * 2);
        DensityFunction oreVeininess = NoiseRouterData.m_209471_((DensityFunction)y, (DensityFunction)DensityFunctions.m_208368_((Holder)noiseParams.m_255043_(Noises.f_189247_), (double)1.5, (double)1.5), (int)minY, (int)maxY, (int)0);
        DensityFunction oreVeinA = NoiseRouterData.m_209471_((DensityFunction)y, (DensityFunction)DensityFunctions.m_208368_((Holder)noiseParams.m_255043_(Noises.f_189248_), (double)4.0, (double)4.0), (int)minY, (int)maxY, (int)0).m_208229_();
        DensityFunction oreVeinB = NoiseRouterData.m_209471_((DensityFunction)y, (DensityFunction)DensityFunctions.m_208368_((Holder)noiseParams.m_255043_(Noises.f_189249_), (double)4.0, (double)4.0), (int)minY, (int)maxY, (int)0).m_208229_();
        DensityFunction oreVein = DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)-0.08f), (DensityFunction)DensityFunctions.m_208382_((DensityFunction)oreVeinA, (DensityFunction)oreVeinB));
        DensityFunction oreGap = DensityFunctions.m_208322_((Holder)noiseParams.m_255043_(Noises.f_189250_));
        return new NoiseRouter(aquiferBarrier, aquiferFluidLevelFloodedness, aquiferFluidLevelSpread, aquiferLava, (DensityFunction)temperature, (DensityFunction)vegetation, NoiseRouterData.m_255403_(densityFunctions, (ResourceKey)NoiseRouterData.f_209451_), NoiseRouterData.m_255403_(densityFunctions, (ResourceKey)NoiseRouterData.f_209452_), DensityFunctions.m_208293_((DensityFunction)depth, (DensityFunction)DensityFunctions.m_208264_((double)-0.205)), NoiseRouterData.m_255403_(densityFunctions, (ResourceKey)NoiseRouterData.f_209453_), PresetNoiseRouterData.slideOverworld(DensityFunctions.m_208293_((DensityFunction)initialDensity, (DensityFunction)DensityFunctions.m_208264_((double)-0.703125)).m_208220_(-64.0, 64.0), -worldDepth), finalDensity, oreVeininess, oreVein, oreGap);
    }

    private static DensityFunction underground(float cheeseCaveProbability, HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParams, DensityFunction slopedCheese) {
        DensityFunction spaghetti2d = NoiseRouterData.m_255403_(densityFunctions, (ResourceKey)NoiseRouterData.f_209439_);
        DensityFunction spaghettiRoughnessFunction = NoiseRouterData.m_255403_(densityFunctions, (ResourceKey)NoiseRouterData.f_209463_);
        DensityFunction caveLayerNoise = DensityFunctions.m_208324_((Holder)noiseParams.m_255043_(Noises.f_189245_), (double)8.0);
        DensityFunction caveLayer = DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)4.0), (DensityFunction)caveLayerNoise.m_208230_());
        DensityFunction caveCheese = PresetNoiseRouterData.probabilityDensity(cheeseCaveProbability, DensityFunctions.m_208324_((Holder)noiseParams.m_255043_(Noises.f_189246_), (double)0.6666666666666666));
        DensityFunction slopedCaves = DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)0.27), (DensityFunction)caveCheese).m_208220_(-1.0, 1.0), (DensityFunction)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)1.5), (DensityFunction)DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)-0.64), (DensityFunction)slopedCheese)).m_208220_(0.0, 0.5));
        DensityFunction slopedCaveLayered = DensityFunctions.m_208293_((DensityFunction)caveLayer, (DensityFunction)slopedCaves);
        DensityFunction underground = DensityFunctions.m_208375_((DensityFunction)DensityFunctions.m_208375_((DensityFunction)slopedCaveLayered, (DensityFunction)NoiseRouterData.m_255403_(densityFunctions, (ResourceKey)NoiseRouterData.f_209464_)), (DensityFunction)DensityFunctions.m_208293_((DensityFunction)spaghetti2d, (DensityFunction)spaghettiRoughnessFunction));
        DensityFunction pillars = NoiseRouterData.m_255403_(densityFunctions, (ResourceKey)NoiseRouterData.f_209437_);
        DensityFunction pillarRange = DensityFunctions.m_208287_((DensityFunction)pillars, (double)-1000000.0, (double)0.03, (DensityFunction)DensityFunctions.m_208264_((double)-1000000.0), (DensityFunction)pillars);
        return DensityFunctions.m_208382_((DensityFunction)underground, (DensityFunction)pillarRange);
    }

    private static DensityFunction spaghetti2D(int minY, int maxY, HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParams) {
        DensityFunction modulator = DensityFunctions.m_208368_((Holder)noiseParams.m_255043_(Noises.f_189296_), (double)2.0, (double)1.0);
        DensityFunction sampler = DensityFunctions.m_208315_((DensityFunction)modulator, (Holder)noiseParams.m_255043_(Noises.f_189294_), (DensityFunctions.WeirdScaledSampler.RarityValueMapper)DensityFunctions.WeirdScaledSampler.RarityValueMapper.TYPE2);
        DensityFunction elevation = DensityFunctions.m_208331_((Holder)noiseParams.m_255043_(Noises.f_189295_), (double)0.0, (double)Math.floorDiv(minY, 8), (double)8.0);
        DensityFunction thicknessModulator = NoiseRouterData.m_255403_(densityFunctions, (ResourceKey)NoiseRouterData.f_209438_);
        DensityFunction elevationGradient = DensityFunctions.m_208293_((DensityFunction)elevation, (DensityFunction)DensityFunctions.m_208266_((int)minY, (int)maxY, (double)((double)minY / -8.0), (double)((double)maxY / -8.0))).m_208229_();
        DensityFunction normal = DensityFunctions.m_208293_((DensityFunction)elevationGradient, (DensityFunction)thicknessModulator).m_208231_();
        DensityFunction weird = DensityFunctions.m_208293_((DensityFunction)sampler, (DensityFunction)DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)0.083), (DensityFunction)thicknessModulator));
        return DensityFunctions.m_208382_((DensityFunction)weird, (DensityFunction)normal).m_208220_(-1.0, 1.0);
    }

    private static DensityFunction noodle(int minY, int maxY, float threshold, HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParams) {
        int baseY = minY + 4;
        DensityFunction y = NoiseRouterData.m_255403_(densityFunctions, (ResourceKey)NoiseRouterData.f_209447_);
        DensityFunction selector = NoiseRouterData.m_209471_((DensityFunction)y, (DensityFunction)DensityFunctions.m_208368_((Holder)noiseParams.m_255043_(Noises.f_189251_), (double)1.0, (double)1.0), (int)baseY, (int)maxY, (int)-1);
        DensityFunction thickness = NoiseRouterData.m_209471_((DensityFunction)y, (DensityFunction)DensityFunctions.m_208336_((Holder)noiseParams.m_255043_(Noises.f_189252_), (double)1.0, (double)1.0, (double)-0.05, (double)-0.1), (int)baseY, (int)maxY, (int)0);
        DensityFunction ridgeA = NoiseRouterData.m_209471_((DensityFunction)y, (DensityFunction)DensityFunctions.m_208368_((Holder)noiseParams.m_255043_(Noises.f_189253_), (double)2.6666666666666665, (double)2.6666666666666665), (int)baseY, (int)maxY, (int)0);
        DensityFunction ridgeB = NoiseRouterData.m_209471_((DensityFunction)y, (DensityFunction)DensityFunctions.m_208368_((Holder)noiseParams.m_255043_(Noises.f_189254_), (double)2.6666666666666665, (double)2.6666666666666665), (int)baseY, (int)maxY, (int)0);
        DensityFunction ridge = DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)1.5), (DensityFunction)DensityFunctions.m_208382_((DensityFunction)ridgeA.m_208229_(), (DensityFunction)ridgeB.m_208229_()));
        return DensityFunctions.m_208287_((DensityFunction)selector, (double)-1000000.0, (double)threshold, (DensityFunction)DensityFunctions.m_208264_((double)64.0), (DensityFunction)DensityFunctions.m_208293_((DensityFunction)thickness, (DensityFunction)ridge));
    }

    private static DensityFunction slideOverworld(DensityFunction function, int minY) {
        return PresetNoiseRouterData.slide(function, minY, 0, 24, 0.1171875);
    }

    private static DensityFunction slide(DensityFunction function, int minY, int bottomGradientStart, int bottomGradientEnd, double bottomGradientTarget) {
        DensityFunction bottomGradient = DensityFunctions.m_208266_((int)(minY + bottomGradientStart), (int)(minY + bottomGradientEnd), (double)0.0, (double)1.0);
        return DensityFunctions.m_224030_((DensityFunction)bottomGradient, (double)bottomGradientTarget, (DensityFunction)function);
    }

    private static DensityFunction jaggednessPerformanceHack() {
        return DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208263_(), (DensityFunction)DensityFunctions.m_208263_());
    }

    @Deprecated
    private static DensityFunction probabilityDensity(float probability, DensityFunction function) {
        if (probability == 0.0f) {
            return DensityFunctions.m_208264_((double)1.0);
        }
        return DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)(1.0f - probability)), (DensityFunction)function);
    }

    private static float yGradientRange(float range) {
        return 1.0f + -range / 128.0f;
    }

    private static ResourceKey<DensityFunction> createKey(String string) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_257040_, (ResourceLocation)RTFCommon.location(string));
    }
}

