/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.data.worldgen.preset;

import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import raccoonman.reterraforged.data.worldgen.preset.PresetNoiseData;
import raccoonman.reterraforged.data.worldgen.preset.settings.Preset;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;
import raccoonman.reterraforged.world.worldgen.noise.module.Noises;
import raccoonman.reterraforged.world.worldgen.util.Seed;

public class PresetStrataNoise {
    public static final ResourceKey<Noise> STRATA_SELECTOR = PresetStrataNoise.createKey("selector");
    public static final ResourceKey<Noise> STRATA_DEPTH = PresetStrataNoise.createKey("depth");

    public static void bootstrap(Preset preset, BootstapContext<Noise> ctx) {
        Seed seed = new Seed(1234153);
        int strataScale = preset.miscellaneous().strataRegionSize;
        Noise selector = Noises.worley(seed.next(), strataScale);
        selector = Noises.warpPerlin(selector, seed.next(), strataScale / 4, 2, (float)strataScale / 2.0f);
        selector = Noises.warpPerlin(selector, seed.next(), 15, 2, 30.0f);
        ctx.m_255272_(STRATA_SELECTOR, (Object)selector);
        ctx.m_255272_(STRATA_DEPTH, (Object)Noises.perlin(seed.next(), strataScale, 3));
    }

    private static ResourceKey<Noise> createKey(String name) {
        return PresetNoiseData.createKey("strata/" + name);
    }
}

