/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.data.worldgen.preset.settings;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public class FilterSettings {
    public static final Codec<FilterSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Erosion.CODEC.fieldOf("erosion").forGetter(o -> o.erosion), (App)Smoothing.CODEC.fieldOf("smoothing").forGetter(o -> o.smoothing)).apply((Applicative)instance, FilterSettings::new));
    public Erosion erosion;
    public Smoothing smoothing;

    public FilterSettings(Erosion erosion, Smoothing smoothing) {
        this.erosion = erosion;
        this.smoothing = smoothing;
    }

    public FilterSettings copy() {
        return new FilterSettings(this.erosion.copy(), this.smoothing.copy());
    }

    public static class Erosion {
        public static final Codec<Erosion> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("dropletsPerChunk").forGetter(o -> o.dropletsPerChunk), (App)Codec.INT.fieldOf("dropletLifetime").forGetter(o -> o.dropletLifetime), (App)Codec.FLOAT.fieldOf("dropletVolume").forGetter(o -> Float.valueOf(o.dropletVolume)), (App)Codec.FLOAT.fieldOf("dropletVelocity").forGetter(o -> Float.valueOf(o.dropletVelocity)), (App)Codec.FLOAT.fieldOf("erosionRate").forGetter(o -> Float.valueOf(o.erosionRate)), (App)Codec.FLOAT.fieldOf("depositeRate").forGetter(o -> Float.valueOf(o.depositeRate))).apply((Applicative)instance, Erosion::new));
        public int dropletsPerChunk;
        public int dropletLifetime;
        public float dropletVolume;
        public float dropletVelocity;
        public float erosionRate;
        public float depositeRate;

        public Erosion(int dropletsPerChunk, int dropletsLifetime, float dropletVolume, float dropletVelocity, float erosionRate, float depositeRate) {
            this.dropletsPerChunk = dropletsPerChunk;
            this.dropletLifetime = dropletsLifetime;
            this.dropletVolume = dropletVolume;
            this.dropletVelocity = dropletVelocity;
            this.erosionRate = erosionRate;
            this.depositeRate = depositeRate;
        }

        public Erosion copy() {
            return new Erosion(this.dropletsPerChunk, this.dropletLifetime, this.dropletVolume, this.dropletVelocity, this.erosionRate, this.depositeRate);
        }
    }

    public static class Smoothing {
        public static final Codec<Smoothing> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("iterations").forGetter(o -> o.iterations), (App)Codec.FLOAT.fieldOf("smoothingRadius").forGetter(o -> Float.valueOf(o.smoothingRadius)), (App)Codec.FLOAT.fieldOf("smoothingRate").forGetter(o -> Float.valueOf(o.smoothingRate))).apply((Applicative)instance, Smoothing::new));
        public int iterations;
        public float smoothingRadius;
        public float smoothingRate;

        public Smoothing(int iterations, float smoothingRadius, float smoothingRate) {
            this.iterations = iterations;
            this.smoothingRadius = smoothingRadius;
            this.smoothingRate = smoothingRate;
        }

        public Smoothing copy() {
            return new Smoothing(this.iterations, this.smoothingRadius, this.smoothingRate);
        }
    }
}

