/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.data.worldgen.preset.settings;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.DensityFunction;
import raccoonman.reterraforged.data.worldgen.compat.terrablender.TBNoiseRouterData;
import raccoonman.reterraforged.data.worldgen.preset.PresetBiomeData;
import raccoonman.reterraforged.data.worldgen.preset.PresetBiomeModifierData;
import raccoonman.reterraforged.data.worldgen.preset.PresetConfiguredCarvers;
import raccoonman.reterraforged.data.worldgen.preset.PresetConfiguredFeatures;
import raccoonman.reterraforged.data.worldgen.preset.PresetDimensionTypes;
import raccoonman.reterraforged.data.worldgen.preset.PresetNoiseData;
import raccoonman.reterraforged.data.worldgen.preset.PresetNoiseGeneratorSettings;
import raccoonman.reterraforged.data.worldgen.preset.PresetNoiseRouterData;
import raccoonman.reterraforged.data.worldgen.preset.PresetPlacedFeatures;
import raccoonman.reterraforged.data.worldgen.preset.PresetStructureRuleData;
import raccoonman.reterraforged.data.worldgen.preset.settings.CaveSettings;
import raccoonman.reterraforged.data.worldgen.preset.settings.ClimateSettings;
import raccoonman.reterraforged.data.worldgen.preset.settings.FilterSettings;
import raccoonman.reterraforged.data.worldgen.preset.settings.MiscellaneousSettings;
import raccoonman.reterraforged.data.worldgen.preset.settings.RiverSettings;
import raccoonman.reterraforged.data.worldgen.preset.settings.StructureSettings;
import raccoonman.reterraforged.data.worldgen.preset.settings.SurfaceSettings;
import raccoonman.reterraforged.data.worldgen.preset.settings.TerrainSettings;
import raccoonman.reterraforged.data.worldgen.preset.settings.WorldSettings;
import raccoonman.reterraforged.registries.RTFRegistries;

public record Preset(WorldSettings world, SurfaceSettings surface, CaveSettings caves, ClimateSettings climate, TerrainSettings terrain, RiverSettings rivers, FilterSettings filters, StructureSettings structures, MiscellaneousSettings miscellaneous) {
    public static final Codec<Preset> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)WorldSettings.CODEC.fieldOf("world").forGetter(Preset::world), (App)SurfaceSettings.CODEC.optionalFieldOf("surface", (Object)new SurfaceSettings(new SurfaceSettings.Erosion(30, 140, 40, 95, 0.65f, 0.475f, 0.4f))).forGetter(Preset::surface), (App)CaveSettings.CODEC.optionalFieldOf("caves", (Object)new CaveSettings(0.0f, 1.5625f, 1.0f, 1.0f, 1.0f, 0.14285715f, 0.07f, 0.02f, true, false)).forGetter(Preset::caves), (App)ClimateSettings.CODEC.fieldOf("climate").forGetter(Preset::climate), (App)TerrainSettings.CODEC.fieldOf("terrain").forGetter(Preset::terrain), (App)RiverSettings.CODEC.fieldOf("rivers").forGetter(Preset::rivers), (App)FilterSettings.CODEC.fieldOf("filters").forGetter(Preset::filters), (App)StructureSettings.CODEC.fieldOf("structures").forGetter(Preset::structures), (App)MiscellaneousSettings.CODEC.fieldOf("miscellaneous").forGetter(Preset::miscellaneous)).apply((Applicative)instance, Preset::new));
    @Deprecated
    public static final ResourceKey<Preset> KEY = RTFRegistries.createKey(RTFRegistries.PRESET, "preset");

    public Preset copy() {
        return new Preset(this.world.copy(), this.surface.copy(), this.caves.copy(), this.climate.copy(), this.terrain.copy(), this.rivers.copy(), this.filters.copy(), this.structures.copy(), this.miscellaneous.copy());
    }

    public HolderLookup.Provider buildPatch(RegistryAccess registries) {
        RegistrySetBuilder builder = new RegistrySetBuilder();
        this.addPatch(builder, RTFRegistries.PRESET, (preset, ctx) -> ctx.m_255272_(KEY, (Object)preset));
        this.addPatch(builder, RTFRegistries.NOISE, PresetNoiseData::bootstrap);
        this.addPatch(builder, RTFRegistries.BIOME_MODIFIER, PresetBiomeModifierData::bootstrap);
        this.addPatch(builder, RTFRegistries.STRUCTURE_RULE, PresetStructureRuleData::bootstrap);
        this.addPatch(builder, Registries.f_256911_, (preset, ctx) -> PresetConfiguredFeatures.bootstrap(preset, ctx));
        this.addPatch(builder, Registries.f_257003_, (preset, ctx) -> PresetConfiguredCarvers.bootstrap(preset, ctx));
        this.addPatch(builder, Registries.f_256988_, PresetPlacedFeatures::bootstrap);
        this.addPatch(builder, Registries.f_256952_, PresetBiomeData::bootstrap);
        this.addPatch(builder, Registries.f_256787_, PresetDimensionTypes::bootstrap);
        this.addPatch(builder, Registries.f_257040_, (preset, ctx) -> {
            PresetNoiseRouterData.bootstrap(preset, (BootstapContext<DensityFunction>)ctx);
            TBNoiseRouterData.bootstrap((BootstapContext<DensityFunction>)ctx);
        });
        this.addPatch(builder, Registries.f_256932_, PresetNoiseGeneratorSettings::bootstrap);
        return builder.m_254929_((RegistryAccess)RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_), (HolderLookup.Provider)registries);
    }

    private <T> void addPatch(RegistrySetBuilder builder, ResourceKey<? extends Registry<T>> key, Patch<T> patch) {
        builder.m_254916_(key, ctx -> patch.apply(this, ctx));
    }

    private static interface Patch<T> {
        public void apply(Preset var1, BootstapContext<T> var2);
    }
}

