/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.data.worldgen.preset.settings;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public class StructureSettings {
    public static final Codec<StructureSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)ResourceKey.m_195966_((ResourceKey)Registries.f_256998_), StructureSetEntry.CODEC).fieldOf("structures").forGetter(s -> s.entries)).apply((Applicative)instance, StructureSettings::new));
    public Map<ResourceKey<StructureSet>, StructureSetEntry> entries;

    public StructureSettings(Map<ResourceKey<StructureSet>, StructureSetEntry> entries) {
        this.entries = new HashMap<ResourceKey<StructureSet>, StructureSetEntry>(entries);
    }

    public StructureSettings() {
        this((Map<ResourceKey<StructureSet>, StructureSetEntry>)ImmutableMap.of());
    }

    public StructureSettings copy() {
        HashMap<ResourceKey<StructureSet>, StructureSetEntry> entries = new HashMap<ResourceKey<StructureSet>, StructureSetEntry>();
        for (Map.Entry<ResourceKey<StructureSet>, StructureSetEntry> entry : this.entries.entrySet()) {
            entries.put(entry.getKey(), entry.getValue().copy());
        }
        return new StructureSettings(entries);
    }

    public static class StructureSetEntry {
        public static final Codec<StructureSetEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("spacing").forGetter(s -> s.spacing), (App)Codec.INT.fieldOf("separation").forGetter(s -> s.separation), (App)Codec.INT.fieldOf("salt").forGetter(s -> s.salt), (App)Codec.BOOL.fieldOf("disabled").forGetter(s -> s.disabled)).apply((Applicative)instance, StructureSetEntry::new));
        public int spacing;
        public int separation;
        public int salt;
        public boolean disabled;

        public StructureSetEntry(int spacing, int separation, int salt, boolean disabled) {
            this.spacing = spacing;
            this.separation = separation;
            this.salt = salt;
            this.disabled = disabled;
        }

        public StructureSetEntry copy() {
            return new StructureSetEntry(this.spacing, this.separation, this.salt, this.disabled);
        }
    }
}

