/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.platform.forge;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.RegistryBuilder;
import raccoonman.reterraforged.platform.forge.DeferredRegistry;
import raccoonman.reterraforged.registries.RTFRegistries;

public final class RegistryUtilImpl {
    private static final Map<ResourceKey<? extends Registry<?>>, DeferredRegistry.Writable<?>> REGISTERS = new ConcurrentHashMap();
    private static final List<DataRegistry<?>> DATA_REGISTRIES = Collections.synchronizedList(new ArrayList());

    public static void register(IEventBus bus) {
        for (DeferredRegistry.Writable<?> registry : REGISTERS.values()) {
            registry.register(bus);
        }
        bus.addListener(event -> {
            for (DataRegistry<?> registry : DATA_REGISTRIES) {
                event.dataPackRegistry(registry.key(), registry.codec());
            }
        });
    }

    public static <T> WritableRegistry<T> getWritable(Registry<T> registry) {
        return REGISTERS.computeIfAbsent(registry.m_123023_(), k -> new DeferredRegistry.Writable(DeferredRegister.create((ResourceKey)k, (String)"reterraforged")));
    }

    public static <T> Registry<T> createRegistry(ResourceKey<? extends Registry<T>> key) {
        if (!key.equals(RTFRegistries.BIOME_MODIFIER_TYPE)) {
            DeferredRegister register = DeferredRegister.create(key, (String)"reterraforged");
            register.makeRegistry(() -> new RegistryBuilder().hasTags());
            REGISTERS.put(key, new DeferredRegistry.Writable(register));
        }
        return DeferredRegistry.memoize(key, () -> GameData.getWrapper((ResourceKey)key, (Lifecycle)Lifecycle.stable()));
    }

    public static <T> void createDataRegistry(ResourceKey<? extends Registry<T>> key, Codec<T> codec) {
        DATA_REGISTRIES.add(new DataRegistry<T>(key, codec));
    }

    private record DataRegistry<T>(ResourceKey<? extends Registry<T>> key, Codec<T> codec) {
    }
}

