/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.biome.modifier.forge;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import org.jetbrains.annotations.Nullable;
import raccoonman.reterraforged.forge.mixin.MixinBiomeGenerationSettingsPlainsBuilder;
import raccoonman.reterraforged.world.worldgen.biome.modifier.Filter;
import raccoonman.reterraforged.world.worldgen.biome.modifier.Order;
import raccoonman.reterraforged.world.worldgen.biome.modifier.forge.ForgeBiomeModifier;

record AddModifier(Order order, GenerationStep.Decoration step, Optional<Filter> biomes, HolderSet<PlacedFeature> features) implements ForgeBiomeModifier
{
    public static final Codec<AddModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Order.CODEC.fieldOf("order").forGetter(AddModifier::order), (App)GenerationStep.Decoration.f_224188_.fieldOf("step").forGetter(AddModifier::step), (App)Filter.CODEC.optionalFieldOf("biomes").forGetter(AddModifier::biomes), (App)PlacedFeature.f_191774_.fieldOf("features").forGetter(AddModifier::features)).apply((Applicative)instance, AddModifier::new));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.AFTER_EVERYTHING) {
            BiomeGenerationSettingsBuilder biomeGenerationSettingsBuilder = builder.getGenerationSettings();
            if (biomeGenerationSettingsBuilder instanceof MixinBiomeGenerationSettingsPlainsBuilder) {
                MixinBiomeGenerationSettingsPlainsBuilder builderAccessor = (MixinBiomeGenerationSettingsPlainsBuilder)biomeGenerationSettingsBuilder;
                if (this.biomes.isPresent() && !this.biomes.get().test(biome)) {
                    return;
                }
                List<List<Holder<PlacedFeature>>> featureSteps = builderAccessor.getFeatures();
                int index = this.step.ordinal();
                while (index >= featureSteps.size()) {
                    featureSteps.add(Collections.emptyList());
                }
                featureSteps.set(index, this.add(featureSteps.get(index)));
            } else {
                throw new IllegalStateException();
            }
        }
    }

    public Codec<AddModifier> codec() {
        return CODEC;
    }

    private List<Holder<PlacedFeature>> add(@Nullable List<Holder<PlacedFeature>> values) {
        if (values == null) {
            return this.features.m_203614_().toList();
        }
        return this.order.add(values, this.features.m_203614_().toList());
    }
}

