/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.biome.modifier.forge;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import raccoonman.reterraforged.forge.mixin.MixinBiomeGenerationSettingsPlainsBuilder;
import raccoonman.reterraforged.world.worldgen.biome.modifier.forge.ForgeBiomeModifier;

record ReplaceModifier(GenerationStep.Decoration step, Optional<HolderSet<Biome>> biomes, Map<ResourceKey<PlacedFeature>, Holder<PlacedFeature>> replacements) implements ForgeBiomeModifier
{
    public static final Codec<ReplaceModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GenerationStep.Decoration.f_224188_.fieldOf("step").forGetter(ReplaceModifier::step), (App)Biome.f_47432_.optionalFieldOf("biomes").forGetter(ReplaceModifier::biomes), (App)Codec.unboundedMap((Codec)ResourceKey.m_195966_((ResourceKey)Registries.f_256988_), (Codec)PlacedFeature.f_191773_).fieldOf("replacements").forGetter(ReplaceModifier::replacements)).apply((Applicative)instance, ReplaceModifier::new));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.AFTER_EVERYTHING) {
            BiomeGenerationSettingsBuilder biomeGenerationSettingsBuilder = builder.getGenerationSettings();
            if (biomeGenerationSettingsBuilder instanceof MixinBiomeGenerationSettingsPlainsBuilder) {
                MixinBiomeGenerationSettingsPlainsBuilder builderAccessor = (MixinBiomeGenerationSettingsPlainsBuilder)biomeGenerationSettingsBuilder;
                if (this.biomes.isPresent() && !this.biomes.get().m_203333_(biome)) {
                    return;
                }
                List<List<Holder<PlacedFeature>>> featureSteps = builderAccessor.getFeatures();
                int index = this.step.ordinal();
                while (index >= featureSteps.size()) {
                    featureSteps.add(Collections.emptyList());
                }
                featureSteps.get(index).replaceAll(f -> f.m_203543_().map(this.replacements::get).orElse((Holder)f));
            } else {
                throw new IllegalStateException();
            }
        }
    }

    public Codec<ReplaceModifier> codec() {
        return CODEC;
    }
}

