/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.cell;

import raccoonman.reterraforged.concurrent.Resource;
import raccoonman.reterraforged.concurrent.SimpleResource;
import raccoonman.reterraforged.concurrent.pool.ThreadLocalPool;
import raccoonman.reterraforged.world.worldgen.cell.biome.type.BiomeType;
import raccoonman.reterraforged.world.worldgen.cell.terrain.Terrain;
import raccoonman.reterraforged.world.worldgen.cell.terrain.TerrainType;

public class Cell {
    private static final Cell DEFAULTS = new Cell();
    private static final Cell EMPTY = new Cell(){

        @Override
        public boolean isAbsent() {
            return true;
        }
    };
    private static final ThreadLocalPool<Cell> POOL = new ThreadLocalPool<Cell>(32, Cell::new, Cell::reset);
    public static final ThreadLocal<Resource<Cell>> LOCAL = ThreadLocal.withInitial(() -> new SimpleResource<Cell>(new Cell(), Cell::reset));
    public float height;
    public float heightErosion;
    public float sediment;
    public float gradient;
    public float regionMoisture = 0.5f;
    public float regionTemperature = 0.5f;
    public float continentId;
    public float continentEdge;
    public float continentDistance;
    public float terrainRegionId;
    public float terrainRegionEdge;
    public float biomeRegionId;
    public float biomeRegionEdge = 1.0f;
    public float macroBiomeId;
    public float riverMask = 1.0f;
    public int continentX;
    public int continentZ;
    public boolean erosionMask = false;
    public Terrain terrain = TerrainType.NONE;
    public BiomeType biome = BiomeType.GRASSLAND;
    public float erosion;
    public float weirdness;
    public float temperature;
    public float moisture;
    @Deprecated(forRemoval=true)
    public float beachNoise;

    public void copyFrom(Cell other) {
        this.height = other.height;
        this.heightErosion = other.heightErosion;
        this.sediment = other.sediment;
        this.gradient = other.gradient;
        this.regionMoisture = other.regionMoisture;
        this.regionTemperature = other.regionTemperature;
        this.continentId = other.continentId;
        this.continentEdge = other.continentEdge;
        this.continentDistance = other.continentDistance;
        this.terrainRegionId = other.terrainRegionId;
        this.terrainRegionEdge = other.terrainRegionEdge;
        this.biomeRegionId = other.biomeRegionId;
        this.biomeRegionEdge = other.biomeRegionEdge;
        this.macroBiomeId = other.macroBiomeId;
        this.riverMask = other.riverMask;
        this.continentX = other.continentX;
        this.continentZ = other.continentZ;
        this.erosionMask = other.erosionMask;
        this.terrain = other.terrain;
        this.biome = other.biome;
        this.erosion = other.erosion;
        this.weirdness = other.weirdness;
        this.temperature = other.temperature;
        this.moisture = other.moisture;
        this.beachNoise = other.beachNoise;
    }

    public Cell reset() {
        this.copyFrom(DEFAULTS);
        return this;
    }

    @Deprecated(forRemoval=true)
    public boolean isAbsent() {
        return false;
    }

    @Deprecated(forRemoval=true)
    public static Cell empty() {
        return EMPTY;
    }

    public static Resource<Cell> getResource() {
        Resource<Cell> resource = LOCAL.get();
        if (resource.isOpen()) {
            return POOL.get();
        }
        return resource;
    }

    public static interface Visitor {
        public void visit(Cell var1, int var2, int var3);
    }
}

