/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.cell.climate;

import raccoonman.reterraforged.data.worldgen.preset.settings.ClimateSettings;
import raccoonman.reterraforged.data.worldgen.preset.settings.WorldSettings;
import raccoonman.reterraforged.world.worldgen.cell.Cell;
import raccoonman.reterraforged.world.worldgen.cell.biome.type.BiomeType;
import raccoonman.reterraforged.world.worldgen.cell.continent.Continent;
import raccoonman.reterraforged.world.worldgen.cell.heightmap.Levels;
import raccoonman.reterraforged.world.worldgen.cell.terrain.TerrainType;
import raccoonman.reterraforged.world.worldgen.noise.NoiseUtil;
import raccoonman.reterraforged.world.worldgen.noise.function.DistanceFunction;
import raccoonman.reterraforged.world.worldgen.noise.function.EdgeFunction;
import raccoonman.reterraforged.world.worldgen.noise.module.LegacyMoisture;
import raccoonman.reterraforged.world.worldgen.noise.module.LegacyTemperature;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;
import raccoonman.reterraforged.world.worldgen.noise.module.Noises;
import raccoonman.reterraforged.world.worldgen.util.Seed;

public class ClimateModule {
    private int seed;
    private float biomeFreq;
    private float warpStrength;
    private Noise warpX;
    private Noise warpZ;
    private Noise moisture;
    private Noise temperature;
    private Noise macroBiomeNoise;
    private Continent continent;
    private WorldSettings.ControlPoints controlPoints;
    private Levels levels;

    public ClimateModule(Seed seed, Continent continent, WorldSettings.ControlPoints controlPoints, ClimateSettings climateSettings, Levels levels) {
        Noise macroBiomeNoise;
        int biomeSize = climateSettings.biomeShape.biomeSize;
        float tempScaler = climateSettings.temperature.scale;
        float moistScaler = (float)climateSettings.moisture.scale * 2.5f;
        float biomeFreq = 1.0f / (float)biomeSize;
        float moistureSize = moistScaler * (float)biomeSize;
        float temperatureSize = tempScaler * (float)biomeSize;
        int moistScale = NoiseUtil.round(moistureSize * biomeFreq);
        int tempScale = NoiseUtil.round(temperatureSize * biomeFreq);
        int warpScale = climateSettings.biomeShape.biomeWarpScale;
        this.continent = continent;
        this.seed = seed.next();
        this.biomeFreq = 1.0f / (float)biomeSize;
        this.controlPoints = controlPoints;
        this.warpStrength = climateSettings.biomeShape.biomeWarpStrength;
        this.levels = levels;
        Noise warpX = Noises.simplex(seed.next(), warpScale, 2);
        this.warpX = warpX = Noises.add(warpX, -0.5f);
        Noise warpZ = Noises.simplex(seed.next(), warpScale, 2);
        this.warpZ = warpZ = Noises.add(warpZ, -0.5f);
        Seed moistureSeed = seed.offset(climateSettings.moisture.seedOffset);
        Noise moistureSource = Noises.simplex(moistureSeed.next(), moistScale, 1);
        moistureSource = Noises.clamp(moistureSource, 0.125f, 0.875f);
        moistureSource = Noises.map(moistureSource, 0.0f, 1.0f);
        moistureSource = Noises.frequency(moistureSource, 0.5f, 1.0f);
        Noise moisture = new LegacyMoisture(moistureSource, climateSettings.moisture.falloff);
        moisture = climateSettings.moisture.apply(moisture);
        moisture = Noises.warpPerlin(moisture, moistureSeed.next(), Math.max(1, moistScale / 2), 1, (float)moistScale / 4.0f);
        moisture = Noises.warpPerlin(moisture, moistureSeed.next(), Math.max(1, moistScale / 6), 2, (float)moistScale / 12.0f);
        this.moisture = moisture;
        Seed tempSeed = seed.offset(climateSettings.temperature.seedOffset);
        Noise temperature = new LegacyTemperature(1.0f / (float)tempScale, climateSettings.temperature.falloff);
        temperature = climateSettings.temperature.apply(temperature);
        temperature = Noises.warpPerlin(temperature, tempSeed.next(), tempScale * 4, 2, tempScale * 4);
        temperature = Noises.warpPerlin(temperature, tempSeed.next(), tempScale, 1, tempScale);
        this.temperature = temperature;
        this.macroBiomeNoise = macroBiomeNoise = Noises.worley(seed.next(), climateSettings.biomeShape.macroNoiseSize);
    }

    public void apply(Cell cell, float x, float z, float originalX, float originalZ) {
        this.apply(cell, x, z, originalX, originalZ, true);
    }

    public void apply(Cell cell, float x, float z, float originalX, float originalZ, boolean mask) {
        float ox = this.warpX.compute(x, z, 0) * this.warpStrength;
        float oz = this.warpZ.compute(x, z, 0) * this.warpStrength;
        x += ox;
        z += oz;
        int xr = NoiseUtil.floor(x *= this.biomeFreq);
        int zr = NoiseUtil.floor(z *= this.biomeFreq);
        int cellX = xr;
        int cellZ = zr;
        float centerX = x;
        float centerZ = z;
        float edgeDistance = 999999.0f;
        float edgeDistance2 = 999999.0f;
        DistanceFunction dist = DistanceFunction.EUCLIDEAN;
        for (int dz = -1; dz <= 1; ++dz) {
            for (int dx = -1; dx <= 1; ++dx) {
                float czf;
                int cx = xr + dx;
                int cz = zr + dz;
                NoiseUtil.Vec2f vec = NoiseUtil.cell(this.seed, cx, cz);
                float cxf = (float)cx + vec.x();
                float distance = dist.apply(cxf - x, (czf = (float)cz + vec.y()) - z);
                if (distance < edgeDistance) {
                    edgeDistance2 = edgeDistance;
                    edgeDistance = distance;
                    centerX = cxf;
                    centerZ = czf;
                    cellX = cx;
                    cellZ = cz;
                    continue;
                }
                if (!(distance < edgeDistance2)) continue;
                edgeDistance2 = distance;
            }
        }
        cell.biomeRegionId = this.cellValue(this.seed, cellX, cellZ);
        cell.regionMoisture = this.moisture.compute(centerX, centerZ, 0);
        cell.regionTemperature = this.temperature.compute(centerX, centerZ, 0);
        cell.macroBiomeId = this.macroBiomeNoise.compute(centerX, centerZ, 0);
        int posX = NoiseUtil.floor(centerX / this.biomeFreq);
        int posZ = NoiseUtil.floor(centerZ / this.biomeFreq);
        float continentEdge = this.continent.getLandValue(posX, posZ);
        if (mask) {
            cell.biomeRegionEdge = this.edgeValue(edgeDistance, edgeDistance2);
            this.modifyTerrain(cell, continentEdge);
        }
        cell.regionMoisture = this.modifyMoisture(cell.regionMoisture, continentEdge);
        cell.biome = BiomeType.get(cell.regionTemperature, cell.regionMoisture);
        cell.regionTemperature = this.modifyTemp(cell.height, cell.regionTemperature, originalX, originalZ);
        cell.temperature = cell.biome.getTemperature(cell.biomeRegionId);
        cell.moisture = cell.biome.getMoisture(cell.biomeRegionId);
    }

    private float modifyTemp(float height, float temp, float x, float z) {
        if (height > 0.75f) {
            return Math.max(0.0f, temp - 0.05f);
        }
        if (height > 0.45f) {
            float delta = (height - 0.45f) / 0.3f;
            return Math.max(0.0f, temp - delta * 0.05f);
        }
        if ((height = Math.max(this.levels.ground, height)) >= this.levels.ground) {
            float delta = 1.0f - (height - this.levels.ground) / (0.45f - this.levels.ground);
            return Math.min(1.0f, temp + delta * 0.05f);
        }
        return temp;
    }

    private float modifyMoisture(float moisture, float continentEdge) {
        float limit = 0.75f;
        float range = 1.0f - limit;
        if (continentEdge < limit) {
            float alpha = (limit - continentEdge) / range;
            float multiplier = 1.0f + alpha * range;
            return NoiseUtil.clamp(moisture * multiplier, 0.0f, 1.0f);
        }
        float alpha = (continentEdge - limit) / range;
        float multiplier = 1.0f - alpha * range;
        return moisture *= multiplier;
    }

    private void modifyTerrain(Cell cell, float continentEdge) {
        if (cell.terrain.isOverground() && !cell.terrain.overridesCoast() && continentEdge <= this.controlPoints.coastMarker()) {
            cell.terrain = TerrainType.COAST;
        }
    }

    private float cellValue(int seed, int cellX, int cellY) {
        float value = NoiseUtil.valCoord2D(seed, cellX, cellY);
        return NoiseUtil.map(value, -1.0f, 1.0f, 2.0f);
    }

    private float edgeValue(float distance, float distance2) {
        EdgeFunction edge = EdgeFunction.DISTANCE_2_DIV;
        float value = edge.apply(distance, distance2);
        value = 1.0f - NoiseUtil.map(value, edge.min(), edge.max(), edge.range());
        return value;
    }
}

