/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.cell.continent.simple;

import raccoonman.reterraforged.data.worldgen.preset.settings.WorldSettings;
import raccoonman.reterraforged.world.worldgen.GeneratorContext;
import raccoonman.reterraforged.world.worldgen.cell.Cell;
import raccoonman.reterraforged.world.worldgen.cell.continent.SimpleContinent;
import raccoonman.reterraforged.world.worldgen.cell.continent.simple.SimpleRiverGenerator;
import raccoonman.reterraforged.world.worldgen.cell.rivermap.LegacyRiverCache;
import raccoonman.reterraforged.world.worldgen.cell.rivermap.RiverCache;
import raccoonman.reterraforged.world.worldgen.cell.rivermap.Rivermap;
import raccoonman.reterraforged.world.worldgen.noise.NoiseUtil;
import raccoonman.reterraforged.world.worldgen.noise.domain.Domain;
import raccoonman.reterraforged.world.worldgen.noise.domain.Domains;
import raccoonman.reterraforged.world.worldgen.noise.function.DistanceFunction;
import raccoonman.reterraforged.world.worldgen.noise.function.EdgeFunction;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;
import raccoonman.reterraforged.world.worldgen.noise.module.Noises;
import raccoonman.reterraforged.world.worldgen.util.PosUtil;
import raccoonman.reterraforged.world.worldgen.util.Seed;

public abstract class ContinentGenerator
implements SimpleContinent {
    protected int seed;
    protected float frequency;
    protected int continentScale;
    private DistanceFunction distanceFunc;
    private WorldSettings.ControlPoints controlPoints;
    private float clampMin;
    private float clampMax;
    private float clampRange;
    private float offsetAlpha;
    protected Domain warp;
    protected Noise shape;
    protected RiverCache cache;

    public ContinentGenerator(Seed seed, GeneratorContext context) {
        WorldSettings settings = context.preset.world();
        int tectonicScale = settings.continent.continentScale * 4;
        this.continentScale = settings.continent.continentScale / 2;
        this.seed = seed.next();
        this.distanceFunc = settings.continent.continentShape;
        this.controlPoints = settings.controlPoints;
        this.frequency = 1.0f / (float)tectonicScale;
        this.clampMin = 0.2f;
        this.clampMax = 1.0f;
        this.clampRange = this.clampMax - this.clampMin;
        this.offsetAlpha = context.preset.world().continent.continentJitter;
        Domain warp = Domains.domainPerlin(seed.next(), 20, 2, 20.0f);
        this.warp = warp = Domains.compound(warp, Domains.domainSimplex(seed.next(), this.continentScale, 3, this.continentScale));
        Noise shape = Noises.simplex(seed.next(), settings.continent.continentScale * 2, 1);
        shape = Noises.add(shape, 0.65f);
        this.shape = shape = Noises.clamp(shape, 0.0f, 1.0f);
        this.cache = new LegacyRiverCache(new SimpleRiverGenerator(this, context));
    }

    @Override
    public Rivermap getRivermap(int x, int y) {
        return this.cache.getRivers(x, y);
    }

    @Override
    public void apply(Cell cell, float x, float y) {
        float ox = this.warp.getOffsetX(x, y, 0);
        float oz = this.warp.getOffsetZ(x, y, 0);
        float px = x + ox;
        float py = y + oz;
        int xr = NoiseUtil.floor(px *= this.frequency);
        int yr = NoiseUtil.floor(py *= this.frequency);
        int cellX = xr;
        int cellY = yr;
        float centerX = px;
        float centerY = py;
        float edgeDistance = 999999.0f;
        float edgeDistance2 = 999999.0f;
        for (int dy = -1; dy <= 1; ++dy) {
            for (int dx = -1; dx <= 1; ++dx) {
                float cyf;
                int cx = xr + dx;
                int cy = yr + dy;
                NoiseUtil.Vec2f vec = NoiseUtil.cell(this.seed, cx, cy);
                float cxf = (float)cx + vec.x() * this.offsetAlpha;
                float distance = this.distanceFunc.apply(cxf - px, (cyf = (float)cy + vec.y() * this.offsetAlpha) - py);
                if (distance < edgeDistance) {
                    edgeDistance2 = edgeDistance;
                    edgeDistance = distance;
                    centerX = cxf;
                    centerY = cyf;
                    cellX = cx;
                    cellY = cy;
                    continue;
                }
                if (!(distance < edgeDistance2)) continue;
                edgeDistance2 = distance;
            }
        }
        cell.continentId = this.cellIdentity(this.seed, cellX, cellY);
        cell.continentEdge = this.cellEdgeValue(edgeDistance, edgeDistance2);
        cell.continentX = (int)(centerX / this.frequency);
        cell.continentZ = (int)(centerY / this.frequency);
        cell.continentEdge *= this.getShape(x, y, cell.continentEdge);
    }

    @Override
    public float getEdgeValue(float x, float y) {
        float ox = this.warp.getOffsetX(x, y, 0);
        float oz = this.warp.getOffsetZ(x, y, 0);
        float px = x + ox;
        float py = y + oz;
        int xr = NoiseUtil.floor(px *= this.frequency);
        int yr = NoiseUtil.floor(py *= this.frequency);
        float edgeDistance = 999999.0f;
        float edgeDistance2 = 999999.0f;
        for (int dy = -1; dy <= 1; ++dy) {
            for (int dx = -1; dx <= 1; ++dx) {
                float cyf;
                int cx = xr + dx;
                int cy = yr + dy;
                NoiseUtil.Vec2f vec = NoiseUtil.cell(this.seed, cx, cy);
                float cxf = (float)cx + vec.x() * this.offsetAlpha;
                float distance = this.distanceFunc.apply(cxf - px, (cyf = (float)cy + vec.y() * this.offsetAlpha) - py);
                if (distance < edgeDistance) {
                    edgeDistance2 = edgeDistance;
                    edgeDistance = distance;
                    continue;
                }
                if (!(distance < edgeDistance2)) continue;
                edgeDistance2 = distance;
            }
        }
        float edgeValue = this.cellEdgeValue(edgeDistance, edgeDistance2);
        float shapeNoise = this.getShape(x, y, edgeValue);
        return edgeValue * shapeNoise;
    }

    @Override
    public long getNearestCenter(float x, float z) {
        float ox = this.warp.getOffsetX(x, z, 0);
        float oz = this.warp.getOffsetZ(x, z, 0);
        float px = x + ox;
        float py = z + oz;
        float centerX = px *= this.frequency;
        float centerY = py *= this.frequency;
        int xr = NoiseUtil.floor(px);
        int yr = NoiseUtil.floor(py);
        float edgeDistance = 999999.0f;
        for (int dy = -1; dy <= 1; ++dy) {
            for (int dx = -1; dx <= 1; ++dx) {
                float cyf;
                int cx = xr + dx;
                int cy = yr + dy;
                NoiseUtil.Vec2f vec = NoiseUtil.cell(this.seed, cx, cy);
                float cxf = (float)cx + vec.x() * this.offsetAlpha;
                float distance = this.distanceFunc.apply(cxf - px, (cyf = (float)cy + vec.y() * this.offsetAlpha) - py);
                if (!(distance < edgeDistance)) continue;
                edgeDistance = distance;
                centerX = cxf;
                centerY = cyf;
            }
        }
        int conX = (int)(centerX / this.frequency);
        int conZ = (int)(centerY / this.frequency);
        return PosUtil.pack(conX, conZ);
    }

    @Override
    public float getDistanceToOcean(int cx, int cz, float dx, float dz) {
        float high = this.getDistanceToEdge(cx, cz, dx, dz);
        float low = 0.0f;
        for (int i = 0; i < 50; ++i) {
            float mid = (low + high) / 2.0f;
            float x = (float)cx + dx * mid;
            float z = (float)cz + dz * mid;
            float edge = this.getEdgeValue(x, z);
            if (edge > this.controlPoints.shallowOcean) {
                low = mid;
            } else {
                high = mid;
            }
            if (high - low < 10.0f) break;
        }
        return high;
    }

    @Override
    public float getDistanceToEdge(int cx, int cz, float dx, float dz) {
        float distance = this.continentScale * 4;
        for (int i = 0; i < 10; ++i) {
            float x = (float)cx + dx * distance;
            float z = (float)cz + dz * distance;
            long centerPos = this.getNearestCenter(x, z);
            int conX = PosUtil.unpackLeft(centerPos);
            int conZ = PosUtil.unpackRight(centerPos);
            distance += distance;
            if (conX == cx && conZ == cz) continue;
            float low = 0.0f;
            float high = distance;
            for (int j = 0; j < 50; ++j) {
                float mid = (low + high) / 2.0f;
                float px = (float)cx + dx * mid;
                float pz = (float)cz + dz * mid;
                centerPos = this.getNearestCenter(px, pz);
                conX = PosUtil.unpackLeft(centerPos);
                conZ = PosUtil.unpackRight(centerPos);
                if (conX == cx && conZ == cz) {
                    low = mid;
                } else {
                    high = mid;
                }
                if (high - low < 50.0f) break;
            }
            return high;
        }
        return distance;
    }

    protected float cellIdentity(int seed, int cellX, int cellY) {
        float value = NoiseUtil.valCoord2D(seed, cellX, cellY);
        return NoiseUtil.map(value, -1.0f, 1.0f, 2.0f);
    }

    protected float cellEdgeValue(float distance, float distance2) {
        EdgeFunction edge = EdgeFunction.DISTANCE_2_DIV;
        float value = edge.apply(distance, distance2);
        if ((value = 1.0f - NoiseUtil.map(value, edge.min(), edge.max(), edge.range())) <= this.clampMin) {
            return 0.0f;
        }
        if (value >= this.clampMax) {
            return 1.0f;
        }
        return (value - this.clampMin) / this.clampRange;
    }

    protected float getShape(float x, float z, float edgeValue) {
        if (edgeValue >= this.controlPoints.inland) {
            return 1.0f;
        }
        float alpha = edgeValue / this.controlPoints.inland;
        return this.shape.compute(x, z, 0) * alpha;
    }
}

