/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.cell.terrain;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import raccoonman.reterraforged.world.worldgen.cell.terrain.CompositeTerrain;
import raccoonman.reterraforged.world.worldgen.cell.terrain.ConfiguredTerrain;
import raccoonman.reterraforged.world.worldgen.cell.terrain.Terrain;
import raccoonman.reterraforged.world.worldgen.cell.terrain.TerrainCategory;

public class TerrainType {
    private static final Object LOCK = new Object();
    private static final List<Terrain> REGISTRY = new CopyOnWriteArrayList<Terrain>();
    public static final Terrain NONE = TerrainType.register("none", TerrainCategory.NONE);
    public static final Terrain DEEP_OCEAN = TerrainType.register("deep_ocean", TerrainCategory.DEEP_OCEAN);
    public static final Terrain SHALLOW_OCEAN = TerrainType.register("ocean", TerrainCategory.SHALLOW_OCEAN);
    public static final Terrain COAST = TerrainType.register("coast", TerrainCategory.COAST);
    public static final Terrain BEACH = TerrainType.register("beach", TerrainCategory.BEACH);
    public static final Terrain RIVER = TerrainType.register("river", TerrainCategory.RIVER);
    public static final Terrain LAKE = TerrainType.register("lake", TerrainCategory.LAKE);
    public static final Terrain WETLAND = TerrainType.registerWetlands("wetland", TerrainCategory.WETLAND);
    public static final Terrain FLATS = TerrainType.register("flats", TerrainCategory.FLATLAND);
    public static final Terrain BADLANDS = TerrainType.registerBadlands("badlands", TerrainCategory.FLATLAND);
    public static final Terrain PLATEAU = TerrainType.register("plateau", TerrainCategory.LOWLAND);
    public static final Terrain HILLS = TerrainType.register("hills", TerrainCategory.LOWLAND);
    public static final Terrain MOUNTAINS_1 = TerrainType.registerMountain("mountains_1", TerrainCategory.HIGHLAND);
    public static final Terrain MOUNTAINS_2 = TerrainType.registerMountain("mountains_2", TerrainCategory.HIGHLAND);
    public static final Terrain MOUNTAINS_3 = TerrainType.registerMountain("mountains_3", TerrainCategory.HIGHLAND);
    public static final Terrain MOUNTAIN_CHAIN = TerrainType.registerMountain("mountain_chain", TerrainCategory.HIGHLAND);
    public static final Terrain VOLCANO = TerrainType.registerVolcano("volcano", TerrainCategory.HIGHLAND);
    public static final Terrain VOLCANO_PIPE = TerrainType.registerVolcano("volcano_pipe", TerrainCategory.HIGHLAND);
    public static final Terrain REMOTE_ISLANDS = TerrainType.register("remote_islands", TerrainCategory.ISLAND);
    public static final Terrain LAGOON = TerrainType.register("lagoon", TerrainCategory.ISLAND);
    public static final Terrain DEEP_LAGOON = TerrainType.register("deep_lagoon", TerrainCategory.ISLAND);
    public static final Terrain ARCHIPELAGO = TerrainType.register("archipelago", TerrainCategory.ISLAND);
    public static final Terrain MUSHROOM_ARCHIPELAGO = TerrainType.register("mushroom_archipelago", TerrainCategory.ISLAND);
    public static final Terrain MUSHROOM_FIELDS = TerrainType.register("mushroom_fields", TerrainCategory.ISLAND);

    public static void forEach(Consumer<Terrain> action) {
        REGISTRY.forEach(action);
    }

    public static Optional<Terrain> find(Predicate<Terrain> filter) {
        return REGISTRY.stream().filter(filter).findFirst();
    }

    public static Terrain getOrCreate(String name, Terrain parent) {
        if (parent == null || parent == NONE) {
            return NONE;
        }
        Terrain current = TerrainType.get(name);
        if (current != null) {
            return current;
        }
        return TerrainType.register(new Terrain(0, name, parent));
    }

    public static Terrain get(String name) {
        for (Terrain terrain : REGISTRY) {
            if (!terrain.getName().equalsIgnoreCase(name)) continue;
            return terrain;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Terrain get(int id) {
        Object object = LOCK;
        synchronized (object) {
            if (id >= 0 && id < REGISTRY.size()) {
                return REGISTRY.get(id);
            }
            return NONE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Terrain register(Terrain instance) {
        Object object = LOCK;
        synchronized (object) {
            Terrain current = TerrainType.get(instance.getName());
            if (current != null) {
                return current;
            }
            Terrain terrain = instance.withId(REGISTRY.size());
            REGISTRY.add(terrain);
            return terrain;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Terrain registerComposite(Terrain a, Terrain b) {
        if (a == b) {
            return a;
        }
        Object object = LOCK;
        synchronized (object) {
            Terrain min = a.getId() < b.getId() ? a : b;
            Terrain max = a.getId() > b.getId() ? a : b;
            Terrain current = TerrainType.get(min.getName() + "-" + max.getName());
            if (current != null) {
                return current;
            }
            CompositeTerrain mix = new CompositeTerrain(REGISTRY.size(), min, max);
            REGISTRY.add(mix);
            return mix;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Terrain register(String name, TerrainCategory type) {
        Object object = LOCK;
        synchronized (object) {
            Terrain terrain = new Terrain(REGISTRY.size(), name, type);
            REGISTRY.add(terrain);
            return terrain;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Terrain registerWetlands(String name, TerrainCategory type) {
        Object object = LOCK;
        synchronized (object) {
            ConfiguredTerrain terrain = new ConfiguredTerrain(REGISTRY.size(), name, type, true);
            REGISTRY.add(terrain);
            return terrain;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Terrain registerBadlands(String name, TerrainCategory type) {
        Object object = LOCK;
        synchronized (object) {
            ConfiguredTerrain terrain = new ConfiguredTerrain(REGISTRY.size(), name, type, 0.3f);
            REGISTRY.add(terrain);
            return terrain;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Terrain registerMountain(String name, TerrainCategory type) {
        Object object = LOCK;
        synchronized (object) {
            ConfiguredTerrain terrain = new ConfiguredTerrain(REGISTRY.size(), name, type, true, true);
            REGISTRY.add(terrain);
            return terrain;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Terrain registerVolcano(String name, TerrainCategory type) {
        Object object = LOCK;
        synchronized (object) {
            ConfiguredTerrain terrain = new ConfiguredTerrain(REGISTRY.size(), name, type, true, true){

                @Override
                public boolean isVolcano() {
                    return true;
                }

                @Override
                public boolean overridesCoast() {
                    return true;
                }
            };
            REGISTRY.add(terrain);
            return terrain;
        }
    }
}

