/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.cell.terrain.populator;

import raccoonman.reterraforged.world.worldgen.cell.Cell;
import raccoonman.reterraforged.world.worldgen.cell.CellPopulator;
import raccoonman.reterraforged.world.worldgen.cell.heightmap.Levels;
import raccoonman.reterraforged.world.worldgen.cell.terrain.TerrainType;
import raccoonman.reterraforged.world.worldgen.noise.NoiseUtil;
import raccoonman.reterraforged.world.worldgen.noise.function.Interpolation;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;
import raccoonman.reterraforged.world.worldgen.noise.module.Noises;

public class IslandPopulator
implements CellPopulator {
    private CellPopulator ocean;
    private IslandType upper;
    private Interpolation interpolation;
    private float blendLower;
    private float blendUpper;
    private float blendRange;
    private Noise islandThresholdNoise;
    private Noise islandChanceVarianceNoise;

    public IslandPopulator(Levels levels, CellPopulator ocean, float min, float max) {
        this(levels, ocean, min, max, Interpolation.LINEAR);
    }

    public IslandPopulator(Levels levels, CellPopulator ocean, float min, float max, Interpolation interpolation) {
        this.ocean = ocean;
        this.upper = IslandPopulator.upperPopulator(levels, -5);
        this.interpolation = interpolation;
        this.blendLower = min;
        this.blendUpper = max;
        this.blendRange = this.blendUpper - this.blendLower;
        Noise islandThresholdNoise = Noises.simplex(3526, 1200, 1);
        islandThresholdNoise = Noises.warpPerlin(islandThresholdNoise, 3526, 1200, 3, 600.0f);
        islandThresholdNoise = Noises.clamp(islandThresholdNoise, 0.0f, 1.0f);
        this.islandThresholdNoise = islandThresholdNoise = Noises.map(islandThresholdNoise, 0.7f, 0.8f);
        Noise islandChanceVarianceNoise = Noises.simplex(54326, 1, 3);
        islandChanceVarianceNoise = Noises.clamp(islandChanceVarianceNoise, 0.0f, 1.0f);
        this.islandChanceVarianceNoise = islandChanceVarianceNoise = Noises.map(islandChanceVarianceNoise, -0.05f, 0.2f);
    }

    @Override
    public void apply(Cell cell, float x, float z) {
        float islandThresholdMin = this.islandThresholdNoise.compute(x, z, 0);
        float islandThresholdMax = islandThresholdMin + 4.0f;
        float regionVarianceAlpha = cell.terrainRegionId > this.islandChanceVarianceNoise.compute(cell.continentX, cell.continentZ, 0) ? 0.0f : 1.0f;
        float regionEdgeAlpha = NoiseUtil.clamp(cell.terrainRegionEdge, islandThresholdMin, islandThresholdMax);
        float islandAlpha = cell.continentDistance * regionVarianceAlpha * (regionEdgeAlpha = NoiseUtil.map(regionEdgeAlpha, 0.0f, 1.0f, 2.0f));
        if (islandAlpha < this.blendLower) {
            this.ocean.apply(cell, x, z);
            return;
        }
        if (islandAlpha > this.blendUpper) {
            this.upper.apply(cell, x, z, islandAlpha);
            return;
        }
        float alpha = this.interpolation.apply((islandAlpha - this.blendLower) / this.blendRange);
        this.ocean.apply(cell, x, z);
        float lowerHeight = cell.height;
        this.upper.apply(cell, x, z, islandAlpha);
        float upperHeight = cell.height;
        cell.height = NoiseUtil.lerp(lowerHeight, upperHeight, alpha);
    }

    private static IslandType upperPopulator(Levels levels, int depth) {
        float archipelagoMaxAlpha = 0.01f;
        float archipelagoMin = levels.water(5);
        float archipelagoMax = levels.water(depth);
        return (cell, x, y, islandAlpha) -> {
            float archipelagoAlpha = islandAlpha;
            if (archipelagoAlpha > archipelagoMaxAlpha) {
                archipelagoAlpha -= archipelagoAlpha - archipelagoMaxAlpha;
            }
            cell.terrain = TerrainType.MUSHROOM_FIELDS;
            cell.height = NoiseUtil.lerp(archipelagoMin, archipelagoMax, archipelagoAlpha);
        };
    }

    public static interface IslandType {
        public void apply(Cell var1, float var2, float var3, float var4);
    }
}

