/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.densityfunction;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import raccoonman.reterraforged.world.worldgen.densityfunction.MarkerFunction;

public record ConditionalFlatCache(DensityFunction function) implements MarkerFunction
{
    public static final Codec<ConditionalFlatCache> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DensityFunction.f_208218_.fieldOf("function").forGetter(ConditionalFlatCache::function)).apply((Applicative)instance, ConditionalFlatCache::new));

    @Override
    public double m_207386_(DensityFunction.FunctionContext ctx) {
        return this.function.m_207386_(ctx);
    }

    public KeyDispatchDataCodec<ConditionalFlatCache> m_214023_() {
        return new KeyDispatchDataCodec(CODEC);
    }

    public DensityFunction m_207456_(DensityFunction.Visitor visitor) {
        return visitor.m_214017_((DensityFunction)new ConditionalFlatCache(this.function.m_207456_(visitor)));
    }

    public class Cache
    implements MarkerFunction.Mapped {
        private int firstBlockX;
        private int firstBlockZ;
        private int width;
        private float[] cache;

        public Cache(int firstBlockX, int firstBlockZ, int width) {
            this.firstBlockX = firstBlockX;
            this.firstBlockZ = firstBlockZ;
            this.width = width;
            this.cache = new float[width * width];
            Arrays.fill(this.cache, Float.NaN);
        }

        public double m_207386_(DensityFunction.FunctionContext ctx) {
            int blockX = ctx.m_207115_();
            int blockZ = ctx.m_207113_();
            int cacheX = blockX - this.firstBlockX;
            int cacheZ = blockZ - this.firstBlockZ;
            if (cacheX >= 0 && cacheZ >= 0 && cacheX < this.width && cacheZ < this.width) {
                int index = cacheX * this.width + cacheZ;
                if (Float.isNaN(this.cache[index])) {
                    this.cache[index] = (float)ConditionalFlatCache.this.function.m_207386_(ctx);
                }
                return this.cache[index];
            }
            return ConditionalFlatCache.this.function.m_207386_(ctx);
        }

        public double m_207402_() {
            return ConditionalFlatCache.this.function.m_207402_();
        }

        public double m_207401_() {
            return ConditionalFlatCache.this.function.m_207401_();
        }
    }
}

