/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import raccoonman.reterraforged.world.worldgen.feature.template.BlockUtils;

public class BushFeature
extends Feature<Config> {
    private static final Vec3i[] LOG_POSITIONS = new Vec3i[]{new Vec3i(1, 0, 1), new Vec3i(1, 0, -1), new Vec3i(-1, 0, -1), new Vec3i(-1, 0, 1), new Vec3i(2, 0, 1), new Vec3i(2, 0, -1), new Vec3i(-2, 0, 1), new Vec3i(-2, 0, -1), new Vec3i(1, 0, 2), new Vec3i(1, 0, -2), new Vec3i(-1, 0, 2), new Vec3i(-1, 0, -2)};
    private static final Vec3i[] LEAF_POSITIONS = new Vec3i[]{new Vec3i(0, 0, 1), new Vec3i(0, 0, -1), new Vec3i(1, 0, 0), new Vec3i(-1, 0, 0), new Vec3i(0, 1, 0)};

    public BushFeature(Codec<Config> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<Config> ctx) {
        BlockPos.MutableBlockPos log = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos leaf = new BlockPos.MutableBlockPos();
        WorldGenLevel level = ctx.m_159774_();
        RandomSource rand = ctx.m_225041_();
        BlockPos pos = ctx.m_159777_();
        Config config = (Config)ctx.m_159778_();
        this.place((LevelAccessor)level, log.m_122190_((Vec3i)pos), leaf, rand, config);
        for (float chance = rand.m_188501_(); chance < config.sizeChance; chance += rand.m_188501_()) {
            BushFeature.addToMutable(log, LOG_POSITIONS[rand.m_188503_(LOG_POSITIONS.length)]);
            if (!this.place((LevelAccessor)level, log, leaf, rand, config)) break;
        }
        return false;
    }

    private boolean place(LevelAccessor world, BlockPos.MutableBlockPos center, BlockPos.MutableBlockPos pos, RandomSource random, Config config) {
        if (!BlockUtils.canTreeReplace(world, (BlockPos)center)) {
            return false;
        }
        center.m_122175_(Direction.DOWN, 1);
        if (!BlockUtils.isSoilOrRock(world, (BlockPos)center)) {
            return false;
        }
        center.m_122175_(Direction.UP, 1);
        world.m_7731_((BlockPos)center, config.trunk, 2);
        BlockState leaves = config.leavesWithDistance(1);
        BlockState leavesExtra = config.leavesWithDistance(2);
        for (Vec3i neighbour : LEAF_POSITIONS) {
            if (neighbour.m_123342_() == 0 && random.m_188501_() < config.airChance) continue;
            pos.m_122190_((Vec3i)center);
            BushFeature.addToMutable(pos, neighbour);
            if (!BlockUtils.canTreeReplace(world, (BlockPos)pos)) continue;
            world.m_7731_((BlockPos)pos, leaves, 2);
            if (neighbour.m_123342_() == 0 && random.m_188501_() < config.leafChance) {
                pos.m_122175_(Direction.DOWN, 1);
                if (BlockUtils.canTreeReplace(world, (BlockPos)pos)) {
                    world.m_7731_((BlockPos)pos, leavesExtra, 2);
                }
                pos.m_122175_(Direction.UP, 1);
            }
            if (neighbour.m_123342_() != 0 || !(random.m_188501_() < config.leafChance)) continue;
            pos.m_122175_(Direction.UP, 1);
            if (!BlockUtils.canTreeReplace(world, (BlockPos)pos)) continue;
            world.m_7731_((BlockPos)pos, leavesExtra, 2);
        }
        return true;
    }

    private static void addToMutable(BlockPos.MutableBlockPos pos, Vec3i add) {
        pos.m_122178_(pos.m_123341_() + add.m_123341_(), pos.m_123342_() + add.m_123342_(), pos.m_123343_() + add.m_123343_());
    }

    public record Config(BlockState trunk, BlockState leaves, float airChance, float leafChance, float sizeChance) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.f_61039_.fieldOf("trunk").forGetter(Config::trunk), (App)BlockState.f_61039_.fieldOf("leaves").forGetter(Config::leaves), (App)Codec.FLOAT.optionalFieldOf("air_chance", (Object)Float.valueOf(0.075f)).forGetter(Config::airChance), (App)Codec.FLOAT.optionalFieldOf("leaf_chance", (Object)Float.valueOf(0.075f)).forGetter(Config::leafChance), (App)Codec.FLOAT.optionalFieldOf("size_chance", (Object)Float.valueOf(0.75f)).forGetter(Config::sizeChance)).apply((Applicative)instance, Config::new));

        public BlockState leavesWithDistance(int distance) {
            if (this.leaves.m_61138_((Property)LeavesBlock.f_54418_)) {
                return (BlockState)this.leaves.m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(distance));
            }
            return this.leaves;
        }
    }
}

