/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import raccoonman.reterraforged.tags.RTFBlockTags;
import raccoonman.reterraforged.world.worldgen.GeneratorContext;
import raccoonman.reterraforged.world.worldgen.RTFRandomState;
import raccoonman.reterraforged.world.worldgen.cell.Cell;
import raccoonman.reterraforged.world.worldgen.cell.heightmap.Heightmap;
import raccoonman.reterraforged.world.worldgen.cell.heightmap.Levels;
import raccoonman.reterraforged.world.worldgen.cell.terrain.TerrainType;
import raccoonman.reterraforged.world.worldgen.densityfunction.tile.Tile;
import raccoonman.reterraforged.world.worldgen.feature.ColumnDecorator;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;
import raccoonman.reterraforged.world.worldgen.noise.module.Noises;

public class ErodeFeature
extends Feature<Config> {
    public ErodeFeature(Codec<Config> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<Config> placeContext) {
        RTFRandomState rtfRandomState;
        GeneratorContext generatorContext;
        WorldGenLevel level = placeContext.m_159774_();
        RandomState randomState = level.m_6018_().m_7726_().m_214994_();
        RandomState randomState2 = randomState;
        if (randomState2 instanceof RTFRandomState && (generatorContext = (rtfRandomState = (RTFRandomState)randomState2).generatorContext()) != null) {
            ChunkPos chunkPos = new ChunkPos(placeContext.m_159777_());
            int chunkX = chunkPos.f_45578_;
            int chunkZ = chunkPos.f_45579_;
            ChunkGenerator generator = placeContext.m_159775_();
            ChunkAccess chunk = level.m_6325_(chunkX, chunkZ);
            Tile.Chunk tileChunk = generatorContext.cache.provideAtChunk(chunkX, chunkZ).getChunkReader(chunkX, chunkZ);
            Heightmap heightmap = generatorContext.generator.getHeightmap();
            Levels levels = heightmap.levels();
            Noise rand = Noises.white(heightmap.climate().randomSeed(), 1);
            Noise desertErosionVariance = ErodeFeature.makeDesertErosionVariance(levels);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            Config config = (Config)placeContext.m_159778_();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int worldX = chunkPos.m_151382_(x);
                    int worldZ = chunkPos.m_151391_(z);
                    Cell cell = tileChunk.getCell(x, z);
                    int scaledY = levels.scale(cell.height);
                    int surfaceY = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE_WG, x, z);
                    Holder biome = level.m_204166_((BlockPos)pos.m_122178_(worldX, surfaceY, worldZ));
                    pos.m_122178_(worldX, surfaceY, worldZ);
                    if (biome.m_203565_(Biomes.f_48203_)) {
                        ErodeFeature.erodeDesert(desertErosionVariance, levels, chunk, cell, pos, surfaceY);
                        continue;
                    }
                    if (surfaceY > scaledY || surfaceY < generator.m_6337_() - 1 || biome.m_203565_(Biomes.f_186753_) || biome.m_203565_(Biomes.f_48159_)) continue;
                    ErodeFeature.erodeColumn(config, rand, generator, chunk, cell, pos, surfaceY);
                    pos.m_142448_(surfaceY);
                    while (!level.m_8055_((BlockPos)pos.m_142448_(pos.m_123342_() + 1)).m_60710_((LevelReader)level, (BlockPos)pos)) {
                        level.m_7731_((BlockPos)pos, Blocks.f_50016_.m_49966_(), 3);
                    }
                }
            }
            return true;
        }
        throw new IllegalStateException();
    }

    @Deprecated(forRemoval=true)
    private static Noise makeDesertErosionVariance(Levels levels) {
        Noise noise = Noises.perlin(435, 8, 1);
        return Noises.mul(noise, levels.scale(16));
    }

    private static void erodeDesert(Noise variance, Levels levels, ChunkAccess chunk, Cell cell, BlockPos.MutableBlockPos pos, int surfaceY) {
        float min = levels.ground(10);
        float threshold = levels.ground(40);
        if (cell.gradient < 0.15f) {
            return;
        }
        if (cell.height < min) {
            return;
        }
        float value = cell.height + variance.compute(pos.m_123341_(), pos.m_123343_(), 0);
        if (cell.gradient > 0.3f || value > threshold) {
            BlockState state = Blocks.f_50471_.m_49966_();
            if (value > threshold) {
                if ((double)cell.gradient > 0.975) {
                    state = Blocks.f_50352_.m_49966_();
                } else if ((double)cell.gradient > 0.85) {
                    state = Blocks.f_50299_.m_49966_();
                } else if ((double)cell.gradient > 0.75) {
                    state = Blocks.f_50288_.m_49966_();
                } else if ((double)cell.gradient > 0.65) {
                    state = Blocks.f_50352_.m_49966_();
                }
            }
            for (int dy = 0; dy < 4; ++dy) {
                chunk.m_6978_((BlockPos)pos.m_142448_(surfaceY - dy), state, false);
            }
        }
    }

    private static void erodeColumn(Config config, Noise rand, ChunkGenerator generator, ChunkAccess chunk, Cell cell, BlockPos.MutableBlockPos pos, int surfaceY) {
        if (cell.terrain.isRiver() || cell.terrain.isWetland()) {
            return;
        }
        if (cell.terrain == TerrainType.VOLCANO_PIPE) {
            return;
        }
        BlockState top = chunk.m_8055_((BlockPos)pos);
        if (top.m_204336_(RTFBlockTags.ERODIBLE)) {
            BlockState blockState;
            if (generator instanceof NoiseBasedChunkGenerator) {
                NoiseBasedChunkGenerator noiseChunkGenerator = (NoiseBasedChunkGenerator)generator;
                blockState = ((NoiseGeneratorSettings)noiseChunkGenerator.m_224341_().m_203334_()).f_64440_();
            } else {
                blockState = Blocks.f_50069_.m_49966_();
            }
            BlockState material = ErodeFeature.getMaterial(config, rand, cell, pos, top, blockState);
            if (material != top) {
                if (material.m_204336_(RTFBlockTags.ROCK)) {
                    ErodeFeature.erodeRock(chunk, cell, pos, surfaceY);
                    return;
                }
                ColumnDecorator.fillDownSolid(chunk, pos, surfaceY, surfaceY - 4, material);
            }
            ErodeFeature.placeScree(config, rand, chunk, cell, pos, surfaceY);
        }
    }

    private static void erodeRock(ChunkAccess chunk, Cell cell, BlockPos.MutableBlockPos pos, int y) {
        int dy;
        int depth = 32;
        BlockState material = Blocks.f_49994_.m_49966_();
        for (dy = 3; dy < 32; ++dy) {
            pos.m_142448_(y - dy);
            BlockState state = chunk.m_8055_((BlockPos)pos);
            if (!state.m_204336_(RTFBlockTags.ROCK)) continue;
            material = state;
            depth = dy + 1;
            break;
        }
        for (dy = 0; dy < depth; ++dy) {
            ColumnDecorator.replaceSolid(chunk, (BlockPos)pos.m_142448_(y - dy), material);
        }
    }

    private static void placeScree(Config config, Noise rand, ChunkAccess chunk, Cell cell, BlockPos.MutableBlockPos pos, int surfaceY) {
        float noise;
        int z;
        int x = pos.m_123341_();
        float steepness = cell.gradient + rand.compute(x, z = pos.m_123343_(), 1) * config.slopeModifier();
        if (steepness < config.screeSteepness()) {
            return;
        }
        float sediment = cell.sediment * config.sedimentNoise();
        if (sediment + (noise = rand.compute(x, z, 2) * config.sedimentNoise()) > config.screeValue()) {
            ColumnDecorator.fillDownSolid(chunk, pos, surfaceY, surfaceY - 2, Blocks.f_49994_.m_49966_());
        }
    }

    private static BlockState getMaterial(Config config, Noise rand, Cell cell, BlockPos.MutableBlockPos pos, BlockState top, BlockState middle) {
        int x = pos.m_123341_();
        int z = pos.m_123343_();
        float height = cell.height + rand.compute(x, z, 0) * config.heightModifier();
        float steepness = cell.gradient + rand.compute(x, z, 1) * config.slopeModifier();
        if (steepness > config.rockSteepness() || height > ColumnDecorator.sampleNoise((float)x, (float)z, config.rockVar(), config.rockMin())) {
            return ErodeFeature.rock(middle);
        }
        if (steepness > config.dirtSteepness() && height > ColumnDecorator.sampleNoise((float)x, (float)z, config.dirtVar(), config.dirtMin())) {
            return ErodeFeature.ground(top);
        }
        return top;
    }

    private static BlockState rock(BlockState state) {
        if (state.m_204336_(RTFBlockTags.ROCK)) {
            return state;
        }
        return Blocks.f_50069_.m_49966_();
    }

    private static BlockState ground(BlockState state) {
        if (state.m_60713_(Blocks.f_50440_) || state.m_60713_(Blocks.f_50195_)) {
            return Blocks.f_50546_.m_49966_();
        }
        if (state.m_204336_(BlockTags.f_13061_)) {
            return Blocks.f_49994_.m_49966_();
        }
        if (state.m_204336_(BlockTags.f_144274_)) {
            return state;
        }
        if (state.m_60713_(Blocks.f_49992_)) {
            return Blocks.f_50471_.m_49966_();
        }
        if (state.m_60713_(Blocks.f_49993_)) {
            return Blocks.f_50473_.m_49966_();
        }
        return Blocks.f_50546_.m_49966_();
    }

    public record Config(int rockVar, int rockMin, int dirtVar, int dirtMin, float rockSteepness, float dirtSteepness, float screeSteepness, float heightModifier, float slopeModifier, float sedimentModifier, float sedimentNoise, float screeValue) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("rock_var").forGetter(Config::rockVar), (App)Codec.INT.fieldOf("rock_min").forGetter(Config::rockMin), (App)Codec.INT.fieldOf("dirt_var").forGetter(Config::dirtVar), (App)Codec.INT.fieldOf("dirt_min").forGetter(Config::dirtMin), (App)Codec.FLOAT.fieldOf("rock_steepness").forGetter(Config::rockSteepness), (App)Codec.FLOAT.fieldOf("dirt_steepness").forGetter(Config::dirtSteepness), (App)Codec.FLOAT.fieldOf("scree_steepness").forGetter(Config::screeSteepness), (App)Codec.FLOAT.fieldOf("height_modifier").forGetter(Config::heightModifier), (App)Codec.FLOAT.fieldOf("slope_modifier").forGetter(Config::slopeModifier), (App)Codec.FLOAT.fieldOf("sediment_modifier").forGetter(Config::sedimentModifier), (App)Codec.FLOAT.fieldOf("sediment_noise").forGetter(Config::sedimentNoise), (App)Codec.FLOAT.fieldOf("screeValue").forGetter(Config::screeValue)).apply((Applicative)instance, Config::new));
    }
}

