/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.feature.chance;

import net.minecraft.util.RandomSource;

public class ChanceContext {
    private int length;
    private float total = 0.0f;
    private float[] buffer;

    public ChanceContext(int length, float total, float[] buffer) {
        this.length = length;
        this.total = total;
        this.buffer = buffer;
    }

    void record(int index, float chance) {
        this.buffer[index] = chance;
        this.total += chance;
        ++this.length;
    }

    int nextIndex(RandomSource random) {
        if (this.total == 0.0f) {
            return -1;
        }
        float value = 0.0f;
        float chance = this.total * random.m_188501_();
        for (int i = 0; i < this.length; ++i) {
            if (!((value += this.buffer[i]) >= chance)) continue;
            return i;
        }
        return -1;
    }

    public static ChanceContext make(int size) {
        float total = 0.0f;
        int length = 0;
        float[] buffer = new float[size];
        return new ChanceContext(length, total, buffer);
    }
}

