/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.feature.chance;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import raccoonman.reterraforged.world.worldgen.feature.chance.ChanceContext;
import raccoonman.reterraforged.world.worldgen.feature.chance.ChanceModifier;

public class ChanceFeature
extends Feature<Config> {
    public ChanceFeature(Codec<Config> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<Config> ctx) {
        RandomSource random = ctx.m_225041_();
        Config config = (Config)ctx.m_159778_();
        int entryCount = config.entries.size();
        ChanceContext chanceCtx = ChanceContext.make(entryCount);
        for (int i = 0; i < entryCount; ++i) {
            Entry entry = config.entries.get(i);
            float chance = entry.getChance(chanceCtx, ctx);
            chanceCtx.record(i, chance);
        }
        int index = chanceCtx.nextIndex(random);
        if (index > -1) {
            return ((PlacedFeature)config.entries.get((int)index).feature.m_203334_()).m_226357_(ctx.m_159774_(), ctx.m_159775_(), random, ctx.m_159777_());
        }
        return false;
    }

    public record Config(List<Entry> entries) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Entry.CODEC.listOf().fieldOf("entries").forGetter(Config::entries)).apply((Applicative)instance, Config::new));
    }

    public record Entry(Holder<PlacedFeature> feature, float chance, List<ChanceModifier> modifiers) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PlacedFeature.f_191773_.fieldOf("feature").forGetter(Entry::feature), (App)Codec.FLOAT.fieldOf("chance").forGetter(Entry::chance), (App)ChanceModifier.CODEC.listOf().fieldOf("modifiers").forGetter(Entry::modifiers)).apply((Applicative)instance, Entry::new));

        public float getChance(ChanceContext chanceCtx, FeaturePlaceContext<?> placeCtx) {
            float chance = this.chance;
            for (ChanceModifier modifier : this.modifiers) {
                chance *= modifier.getChance(chanceCtx, placeCtx);
            }
            return chance;
        }
    }
}

