/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.feature.chance;

import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import raccoonman.reterraforged.world.worldgen.feature.chance.ChanceContext;
import raccoonman.reterraforged.world.worldgen.feature.chance.ChanceModifier;

public abstract class RangeChanceModifier
implements ChanceModifier {
    protected float from;
    protected float to;
    protected boolean exclusive;

    public RangeChanceModifier(float from, float to, boolean exclusive) {
        this.from = from;
        this.to = to;
        this.exclusive = exclusive;
    }

    protected abstract float getValue(ChanceContext var1, FeaturePlaceContext<?> var2);

    @Override
    public float getChance(ChanceContext chanceCtx, FeaturePlaceContext<?> placeCtx) {
        return this.apply(this.getValue(chanceCtx, placeCtx));
    }

    private float apply(float value) {
        float max = this.exclusive ? 0.0f : 1.0f;
        float range = Math.abs(max - this.from);
        if (this.from < this.to) {
            if (value <= this.from) {
                return 0.0f;
            }
            if (value >= this.to) {
                return max;
            }
            return (value - this.from) / range;
        }
        if (this.from > this.to) {
            if (value <= this.to) {
                return max;
            }
            if (value >= this.from) {
                return 0.0f;
            }
            return 1.0f - (value - this.to) / range;
        }
        return 0.0f;
    }
}

