/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.feature.placement.poisson;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import raccoonman.reterraforged.world.worldgen.RTFRandomState;
import raccoonman.reterraforged.world.worldgen.densityfunction.tile.Tile;
import raccoonman.reterraforged.world.worldgen.feature.placement.RTFPlacementModifiers;
import raccoonman.reterraforged.world.worldgen.feature.placement.poisson.BiomeVariance;
import raccoonman.reterraforged.world.worldgen.feature.placement.poisson.DensityNoise;
import raccoonman.reterraforged.world.worldgen.feature.placement.poisson.FastPoisson;
import raccoonman.reterraforged.world.worldgen.feature.placement.poisson.FastPoissonContext;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;
import raccoonman.reterraforged.world.worldgen.noise.module.Noises;

public class FastPoissonModifier
extends PlacementModifier {
    public static final Codec<FastPoissonModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("radius").forGetter(p -> p.radius), (App)Codec.FLOAT.fieldOf("scale").forGetter(p -> Float.valueOf(p.scale)), (App)Codec.FLOAT.fieldOf("jitter").forGetter(p -> Float.valueOf(p.jitter)), (App)Codec.FLOAT.fieldOf("biome_fade").forGetter(p -> Float.valueOf(p.biomeFade)), (App)Codec.INT.fieldOf("density_variance_scale").forGetter(p -> p.densityVariationScale), (App)Codec.FLOAT.fieldOf("density_variation").forGetter(p -> Float.valueOf(p.densityVariation))).apply((Applicative)instance, FastPoissonModifier::new));
    protected int radius;
    protected float scale;
    protected float jitter;
    protected float biomeFade;
    protected int densityVariationScale;
    protected float densityVariation;

    public FastPoissonModifier(int radius, float scale, float jitter, float biomeFade, int densityVariationScale, float densityVariation) {
        this.radius = radius;
        this.scale = scale;
        this.jitter = jitter;
        this.biomeFade = biomeFade;
        this.densityVariationScale = densityVariationScale;
        this.densityVariation = densityVariation;
    }

    public Stream<BlockPos> m_213676_(PlacementContext ctx, RandomSource random, BlockPos pos) {
        WorldGenLevel level = ctx.m_191831_();
        ChunkAccess chunk = ctx.m_191831_().m_46865_(pos);
        long levelSeed = level.m_7328_();
        int seed = (int)levelSeed + 234523;
        ChunkPos chunkPos = chunk.m_7697_();
        int chunkX = chunkPos.f_45578_;
        int chunkZ = chunkPos.f_45579_;
        FastPoisson poisson = FastPoisson.LOCAL_POISSON.get();
        DensityNoise density = this.getDensityNoise(seed, chunkPos, level.m_6018_().m_7726_().m_214994_());
        FastPoissonContext poissonConfig = new FastPoissonContext(this.radius, this.jitter, this.scale, density);
        Stream.Builder builder = Stream.builder();
        poisson.visit(seed, chunkX, chunkZ, new Random(levelSeed), poissonConfig, builder, (x, z, b) -> b.accept(new BlockPos(x, 0, z)));
        return builder.build();
    }

    public PlacementModifierType<FastPoissonModifier> m_183327_() {
        return RTFPlacementModifiers.FAST_POISSON;
    }

    private DensityNoise getDensityNoise(int seed, ChunkPos chunkPos, RandomState randomState) {
        RandomState randomState2;
        BiomeVariance biomeVariance = BiomeVariance.NONE;
        if (this.biomeFade > 0.025f && (randomState2 = randomState) instanceof RTFRandomState) {
            RTFRandomState rtfRandomState = (RTFRandomState)randomState2;
            Tile.Chunk reader = rtfRandomState.generatorContext().cache.provideAtChunk(chunkPos.f_45578_, chunkPos.f_45579_).getChunkReader(chunkPos.f_45578_, chunkPos.f_45579_);
            if (reader != null) {
                biomeVariance = new BiomeVariance(reader, this.biomeFade);
            }
        }
        Noise densityVariance = Noises.one();
        if (this.densityVariation > 0.0f) {
            densityVariance = Noises.simplex(seed + 1, this.densityVariationScale, 1);
            densityVariance = Noises.mul(densityVariance, this.densityVariation);
            densityVariance = Noises.add(densityVariance, 1.0f - this.densityVariation);
        }
        return new DensityNoise(biomeVariance, densityVariance);
    }
}

