/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.feature.template;

import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.pathfinder.PathComputationType;

public class BlockUtils {
    public static boolean isSoil(LevelAccessor world, BlockPos pos) {
        return TreeFeature.m_159759_((BlockState)world.m_8055_(pos));
    }

    public static boolean isLeavesOrLogs(BlockState state) {
        return state.m_204336_(BlockTags.f_13106_) || state.m_204336_(BlockTags.f_13035_);
    }

    public static boolean isVegetation(LevelAccessor world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_204336_(BlockTags.f_13104_) || state.m_204336_(BlockTags.f_13041_) || state.m_60713_(Blocks.f_50191_);
    }

    public static boolean canTreeReplace(LevelAccessor world, BlockPos pos) {
        return TreeFeature.m_67267_((LevelSimulatedReader)world, (BlockPos)pos) || BlockUtils.isVegetation(world, pos);
    }

    public static boolean isSolid(BlockGetter reader, BlockPos pos) {
        BlockState state = reader.m_8055_(pos);
        return BlockUtils.isSolid(state, reader, pos);
    }

    public static boolean isSolid(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.m_60815_() || !state.m_60647_(reader, pos, PathComputationType.LAND);
    }

    public static boolean isSoilOrRock(LevelAccessor world, BlockPos pos) {
        BlockState block = world.m_8055_(pos);
        return TreeFeature.m_159759_((BlockState)block) || block.m_204336_(BlockTags.f_13061_);
    }

    public static boolean isClearOverhead(LevelAccessor world, BlockPos pos, int height, BiPredicate<LevelAccessor, BlockPos> predicate) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int max = Math.min(world.m_151558_() - 1, pos.m_123342_() + height);
        for (int y = pos.m_123342_(); y < max; ++y) {
            mutable.m_122178_(pos.m_123341_(), y, pos.m_123343_());
            if (predicate.test(world, (BlockPos)mutable)) continue;
            return false;
        }
        return true;
    }
}

