/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.feature.template;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import raccoonman.reterraforged.RTFCommon;
import raccoonman.reterraforged.server.RTFMinecraftServer;
import raccoonman.reterraforged.world.worldgen.feature.template.decorator.DecoratorConfig;
import raccoonman.reterraforged.world.worldgen.feature.template.decorator.TemplateDecorator;
import raccoonman.reterraforged.world.worldgen.feature.template.paste.Paste;
import raccoonman.reterraforged.world.worldgen.feature.template.paste.PasteConfig;
import raccoonman.reterraforged.world.worldgen.feature.template.paste.PasteType;
import raccoonman.reterraforged.world.worldgen.feature.template.placement.TemplatePlacement;
import raccoonman.reterraforged.world.worldgen.feature.template.template.Dimensions;
import raccoonman.reterraforged.world.worldgen.feature.template.template.FeatureTemplate;
import raccoonman.reterraforged.world.worldgen.feature.template.template.TemplateContext;

public class TemplateFeature
extends Feature<Config<?>> {
    public TemplateFeature(Codec<Config<?>> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<Config<?>> ctx) {
        RandomSource random = ctx.m_225041_();
        Config config = (Config)ctx.m_159778_();
        Mirror mirror = TemplateFeature.nextMirror(random);
        Rotation rotation = TemplateFeature.nextRotation(random);
        return TemplateFeature.paste(ctx.m_159774_(), random, ctx.m_159777_(), mirror, rotation, config, FeatureTemplate.WORLD_GEN);
    }

    public static <T extends TemplateContext> boolean paste(WorldGenLevel world, RandomSource rand, BlockPos pos, Mirror mirror, Rotation rotation, Config<T> config, PasteType pasteType) {
        return TemplateFeature.paste(world, rand, pos, mirror, rotation, config, pasteType, false);
    }

    public static <T extends TemplateContext> boolean paste(WorldGenLevel world, RandomSource rand, BlockPos pos, Mirror mirror, Rotation rotation, Config<T> config, PasteType pasteType, boolean modified) {
        if (config.templates().isEmpty()) {
            RTFCommon.LOGGER.warn("Empty template list for config");
            return false;
        }
        MinecraftServer minecraftServer = world.m_7654_();
        if (minecraftServer instanceof RTFMinecraftServer) {
            T buffer;
            RTFMinecraftServer rtfMinecraftServer = (RTFMinecraftServer)minecraftServer;
            DecoratorConfig<T> decoratorConfig = config.decorator();
            ResourceLocation templateName = TemplateFeature.nextTemplate(config.templates, rand);
            FeatureTemplate template = rtfMinecraftServer.getFeatureTemplateManager().load(templateName);
            Dimensions dimensions = template.getDimensions(mirror, rotation);
            TemplatePlacement<T> placement = config.placement();
            if (!placement.canPlaceAt((LevelAccessor)world, pos, dimensions)) {
                return false;
            }
            Paste paste = pasteType.get(template);
            if (paste.apply((LevelAccessor)world, buffer = placement.createContext(), pos, mirror, rotation, placement, config.paste())) {
                ResourceLocation biome = world.m_204166_(pos).m_203543_().map(ResourceKey::m_211136_).orElse(null);
                for (TemplateDecorator<T> decorator : decoratorConfig.getDecorators(biome)) {
                    decorator.apply((LevelAccessor)world, buffer, rand, modified);
                }
                return true;
            }
            return false;
        }
        throw new IllegalStateException();
    }

    private static ResourceLocation nextTemplate(List<ResourceLocation> templates, RandomSource random) {
        return templates.get(random.m_188503_(templates.size()));
    }

    private static Mirror nextMirror(RandomSource random) {
        return Mirror.values()[random.m_188503_(Mirror.values().length)];
    }

    private static Rotation nextRotation(RandomSource random) {
        return Rotation.values()[random.m_188503_(Rotation.values().length)];
    }

    public record Config<T extends TemplateContext>(List<ResourceLocation> templates, TemplatePlacement<T> placement, PasteConfig paste, DecoratorConfig<T> decorator) implements FeatureConfiguration
    {
        public static final Codec<Config<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.listOf().fieldOf("templates").forGetter(Config::templates), (App)TemplatePlacement.CODEC.fieldOf("placement").forGetter(Config::placement), (App)PasteConfig.CODEC.fieldOf("paste").forGetter(Config::paste), (App)DecoratorConfig.CODEC.fieldOf("decorator").forGetter(Config::decorator)).apply((Applicative)instance, (templates, placement, paste, decorator) -> new Config((List<ResourceLocation>)templates, placement, (PasteConfig)paste, decorator)));
    }
}

