/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.feature.template.buffer;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import raccoonman.reterraforged.world.worldgen.feature.template.buffer.BufferBitSet;
import raccoonman.reterraforged.world.worldgen.feature.template.buffer.PasteBuffer;
import raccoonman.reterraforged.world.worldgen.feature.template.paste.PasteConfig;
import raccoonman.reterraforged.world.worldgen.feature.template.placement.TemplatePlacement;
import raccoonman.reterraforged.world.worldgen.feature.template.template.BlockInfo;
import raccoonman.reterraforged.world.worldgen.noise.NoiseUtil;

public class TemplateBuffer
extends PasteBuffer {
    private LevelAccessor world;
    private BlockPos origin;
    private final BufferBitSet placementMask = new BufferBitSet();

    public TemplateBuffer() {
        this.setRecording(true);
    }

    public TemplateBuffer init(LevelAccessor world, BlockPos origin, Vec3i p1, Vec3i p2) {
        super.clear();
        this.placementMask.clear();
        this.world = world;
        this.origin = origin;
        this.placementMask.set(p1.m_123341_(), p1.m_123342_(), p1.m_123343_(), p2.m_123341_(), p2.m_123342_(), p2.m_123343_());
        return this;
    }

    public void record(int i, BlockInfo block, BlockPos pastePos, TemplatePlacement<?> placement, PasteConfig config) {
        if (!config.replaceSolid() && !placement.canReplaceAt(this.world, pastePos)) {
            this.placementMask.set(block.pos().m_123341_(), block.pos().m_123342_(), block.pos().m_123343_());
            return;
        }
        if (!config.pasteAir() && block.state().m_60713_(Blocks.f_50016_)) {
            return;
        }
        this.record(i);
    }

    public boolean test(BlockPos pos) {
        int dz;
        int dx = pos.m_123341_() - this.origin.m_123341_();
        if (dx == (dz = pos.m_123343_() - this.origin.m_123343_())) {
            return this.test(pos, 1.0f, 1.0f);
        }
        if (Math.abs(dx) > Math.abs(dz)) {
            return this.test(pos, 1.0f, (float)dz / (float)dx);
        }
        return this.test(pos, (float)dx / (float)dz, 1.0f);
    }

    private boolean test(BlockPos start, float dx, float dz) {
        int x = start.m_123341_();
        int z = start.m_123343_();
        float px = x;
        float pz = z;
        for (int count = 0; x != this.origin.m_123341_() && z != this.origin.m_123343_() && count < 10; ++count) {
            if (this.placementMask.test(x, start.m_123342_(), z)) {
                return false;
            }
            x = NoiseUtil.floor(px -= dx);
            z = NoiseUtil.floor(pz -= dz);
        }
        return true;
    }
}

