/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.feature.template.template;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import raccoonman.reterraforged.world.worldgen.feature.template.template.BlockInfo;
import raccoonman.reterraforged.world.worldgen.feature.template.template.FeatureTemplate;

public class FeatureTemplateManager {
    private ResourceManager resourceManager;
    private Map<ResourceLocation, FeatureTemplate> cache;

    public FeatureTemplateManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.cache = new ConcurrentHashMap<ResourceLocation, FeatureTemplate>();
    }

    public void onReload(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.cache.clear();
    }

    public FeatureTemplate load(ResourceLocation location) {
        return this.cache.computeIfAbsent(location, this::read);
    }

    private FeatureTemplate read(ResourceLocation location) {
        return this.resourceManager.m_213713_(location).flatMap(resource -> {
            Optional<FeatureTemplate> optional;
            block8: {
                InputStream stream = resource.m_215507_();
                try {
                    optional = FeatureTemplate.load(stream);
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return Optional.empty();
                    }
                }
                stream.close();
            }
            return optional;
        }).orElse(new FeatureTemplate((List<BlockInfo>)ImmutableList.of()));
    }
}

