/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.feature.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public record Range(float from, float to, float max, float range, @Deprecated boolean exclusive) {
    public static final Codec<Range> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("from").forGetter(Range::from), (App)Codec.FLOAT.fieldOf("to").forGetter(Range::to), (App)Codec.BOOL.fieldOf("exclusive").forGetter(Range::exclusive)).apply((Applicative)instance, Range::of));

    public float apply(float value) {
        if (this.from < this.to) {
            if (value <= this.from) {
                return 0.0f;
            }
            if (value >= this.to) {
                return this.max;
            }
            return (value - this.from) / this.range;
        }
        if (this.from > this.to) {
            if (value <= this.to) {
                return this.max;
            }
            if (value >= this.from) {
                return 0.0f;
            }
            return 1.0f - (value - this.to) / this.range;
        }
        return 0.0f;
    }

    public static Range of(float from, float to, boolean exclusive) {
        return new Range(from, to, exclusive ? 0.0f : 1.0f, Math.abs(to - from), exclusive);
    }
}

