/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.noise.function;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import raccoonman.reterraforged.world.worldgen.noise.NoiseUtil;
import raccoonman.reterraforged.world.worldgen.noise.function.CurveFunction;

record SCurveFunction(float lower, float upper) implements CurveFunction
{
    public static final Codec<SCurveFunction> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("lower").forGetter(SCurveFunction::lower), (App)Codec.FLOAT.fieldOf("upper").forGetter(SCurveFunction::upper)).apply((Applicative)instance, SCurveFunction::new));

    public SCurveFunction {
        upper = upper < 0.0f ? Math.max(-lower, upper) : upper;
    }

    @Override
    public float apply(float f) {
        return NoiseUtil.pow(f, this.lower + this.upper * f);
    }

    public Codec<SCurveFunction> codec() {
        return CODEC;
    }
}

