/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.noise.module;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import raccoonman.reterraforged.world.worldgen.noise.NoiseUtil;
import raccoonman.reterraforged.world.worldgen.noise.function.Interpolation;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;
import raccoonman.reterraforged.world.worldgen.noise.module.Perlin;

record Billow(float frequency, int octaves, float lacunarity, float gain, Interpolation interpolation, float[] spectralWeights, float min, float max) implements Noise
{
    public static final Codec<Billow> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("frequency").forGetter(Billow::frequency), (App)Codec.INT.fieldOf("octaves").forGetter(Billow::octaves), (App)Codec.FLOAT.fieldOf("lacunarity").forGetter(Billow::lacunarity), (App)Codec.FLOAT.fieldOf("gain").forGetter(Billow::gain), (App)Interpolation.CODEC.fieldOf("interpolation").forGetter(Billow::interpolation)).apply((Applicative)instance, Billow::new));

    public Billow(float frequency, int octaves, float lacunarity, float gain, Interpolation interpolation) {
        this(frequency, octaves, lacunarity, gain, interpolation, Billow.calculateSpectralWeights(octaves, lacunarity));
    }

    private Billow(float frequency, int octaves, float lacunarity, float gain, Interpolation interpolation, float[] spectralWeights) {
        this(frequency, octaves, lacunarity, gain, interpolation, spectralWeights, 0.0f, Billow.calculateMaxBound(spectralWeights, gain));
    }

    public Billow {
        octaves = Math.min(octaves, 30);
    }

    @Override
    public float compute(float x, float z, int seed) {
        x *= this.frequency;
        z *= this.frequency;
        float amp = 2.0f;
        float value = 0.0f;
        float weight = 1.0f;
        for (int octave = 0; octave < this.octaves; ++octave) {
            float signal = Perlin.sample(x, z, seed + octave, this.interpolation);
            signal = 1.0f - Math.abs(signal);
            signal *= signal;
            signal *= weight;
            weight = signal * amp;
            weight = NoiseUtil.clamp(weight, 0.0f, 1.0f);
            value += signal * this.spectralWeights[octave];
            x *= this.lacunarity;
            z *= this.lacunarity;
            amp *= this.gain;
        }
        return 1.0f - NoiseUtil.map(value, this.min, this.max, Math.abs(this.max - this.min));
    }

    @Override
    public float minValue() {
        return 0.0f;
    }

    @Override
    public float maxValue() {
        return 1.0f;
    }

    @Override
    public Noise mapAll(Noise.Visitor visitor) {
        return visitor.apply(this);
    }

    public Codec<Billow> codec() {
        return CODEC;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Billow)) return false;
        Billow other = (Billow)o;
        if (other.frequency != this.frequency) return false;
        if (other.octaves != this.octaves) return false;
        if (other.lacunarity != this.lacunarity) return false;
        if (other.gain != this.gain) return false;
        if (!other.interpolation.equals(this.interpolation)) return false;
        return true;
    }

    private static float[] calculateSpectralWeights(int octaves, float lacunarity) {
        float frequency = 1.0f;
        float[] spectralWeights = new float[octaves];
        for (int i = 0; i < spectralWeights.length; ++i) {
            spectralWeights[i] = NoiseUtil.pow(frequency, -1.0f);
            frequency *= lacunarity;
        }
        return spectralWeights;
    }

    private static float calculateMaxBound(float[] spectralWeights, float gain) {
        float amp = 2.0f;
        float value = 0.0f;
        float weight = 1.0f;
        for (int curOctave = 0; curOctave < spectralWeights.length; ++curOctave) {
            float noise = 1.0f;
            noise *= weight;
            weight = noise * amp;
            weight = Math.min(1.0f, Math.max(0.0f, weight));
            value += noise * spectralWeights[curOctave];
            amp *= gain;
        }
        return value;
    }
}

