/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.noise.module;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;

record Frequency(Noise input, Noise xFreq, Noise zFreq) implements Noise
{
    public static final Codec<Frequency> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Noise.HOLDER_HELPER_CODEC.fieldOf("input").forGetter(Frequency::input), (App)Noise.HOLDER_HELPER_CODEC.fieldOf("x_freq").forGetter(Frequency::xFreq), (App)Noise.HOLDER_HELPER_CODEC.fieldOf("z_freq").forGetter(Frequency::zFreq)).apply((Applicative)instance, Frequency::new));

    @Override
    public float compute(float x, float z, int seed) {
        float xFreq = this.xFreq.compute(x, z, seed);
        float zFreq = this.zFreq.compute(x, z, seed);
        return this.input.compute(x * xFreq, z * zFreq, seed);
    }

    @Override
    public float minValue() {
        return this.input.minValue();
    }

    @Override
    public float maxValue() {
        return this.input.maxValue();
    }

    @Override
    public Noise mapAll(Noise.Visitor visitor) {
        return visitor.apply(new Frequency(this.input.mapAll(visitor), this.xFreq.mapAll(visitor), this.zFreq.mapAll(visitor)));
    }

    public Codec<Frequency> codec() {
        return CODEC;
    }
}

