/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.noise.module;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.core.Holder;
import raccoonman.reterraforged.platform.RegistryUtil;
import raccoonman.reterraforged.registries.RTFBuiltInRegistries;
import raccoonman.reterraforged.world.worldgen.noise.domain.Domain;
import raccoonman.reterraforged.world.worldgen.noise.domain.Domains;
import raccoonman.reterraforged.world.worldgen.noise.function.CellFunction;
import raccoonman.reterraforged.world.worldgen.noise.function.CurveFunction;
import raccoonman.reterraforged.world.worldgen.noise.function.DistanceFunction;
import raccoonman.reterraforged.world.worldgen.noise.function.EdgeFunction;
import raccoonman.reterraforged.world.worldgen.noise.function.Interpolation;
import raccoonman.reterraforged.world.worldgen.noise.module.Abs;
import raccoonman.reterraforged.world.worldgen.noise.module.Add;
import raccoonman.reterraforged.world.worldgen.noise.module.AdvancedTerrace;
import raccoonman.reterraforged.world.worldgen.noise.module.Alpha;
import raccoonman.reterraforged.world.worldgen.noise.module.Billow;
import raccoonman.reterraforged.world.worldgen.noise.module.Blend;
import raccoonman.reterraforged.world.worldgen.noise.module.Boost;
import raccoonman.reterraforged.world.worldgen.noise.module.Cache2d;
import raccoonman.reterraforged.world.worldgen.noise.module.Clamp;
import raccoonman.reterraforged.world.worldgen.noise.module.Constant;
import raccoonman.reterraforged.world.worldgen.noise.module.Cubic;
import raccoonman.reterraforged.world.worldgen.noise.module.Curve;
import raccoonman.reterraforged.world.worldgen.noise.module.Erosion;
import raccoonman.reterraforged.world.worldgen.noise.module.Frequency;
import raccoonman.reterraforged.world.worldgen.noise.module.Gradient;
import raccoonman.reterraforged.world.worldgen.noise.module.Invert;
import raccoonman.reterraforged.world.worldgen.noise.module.LegacyMoisture;
import raccoonman.reterraforged.world.worldgen.noise.module.LegacyTemperature;
import raccoonman.reterraforged.world.worldgen.noise.module.Line;
import raccoonman.reterraforged.world.worldgen.noise.module.LinearSpline;
import raccoonman.reterraforged.world.worldgen.noise.module.Map;
import raccoonman.reterraforged.world.worldgen.noise.module.Max;
import raccoonman.reterraforged.world.worldgen.noise.module.Min;
import raccoonman.reterraforged.world.worldgen.noise.module.Multiply;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;
import raccoonman.reterraforged.world.worldgen.noise.module.Perlin;
import raccoonman.reterraforged.world.worldgen.noise.module.Perlin2;
import raccoonman.reterraforged.world.worldgen.noise.module.PerlinRidge;
import raccoonman.reterraforged.world.worldgen.noise.module.Power;
import raccoonman.reterraforged.world.worldgen.noise.module.PowerCurve;
import raccoonman.reterraforged.world.worldgen.noise.module.ShiftSeed;
import raccoonman.reterraforged.world.worldgen.noise.module.Simplex;
import raccoonman.reterraforged.world.worldgen.noise.module.Simplex2;
import raccoonman.reterraforged.world.worldgen.noise.module.SimplexRidge;
import raccoonman.reterraforged.world.worldgen.noise.module.Sin;
import raccoonman.reterraforged.world.worldgen.noise.module.Steps;
import raccoonman.reterraforged.world.worldgen.noise.module.Terrace;
import raccoonman.reterraforged.world.worldgen.noise.module.Threshold;
import raccoonman.reterraforged.world.worldgen.noise.module.Warp;
import raccoonman.reterraforged.world.worldgen.noise.module.White;
import raccoonman.reterraforged.world.worldgen.noise.module.Worley;
import raccoonman.reterraforged.world.worldgen.noise.module.WorleyEdge;

public class Noises {
    private static final Codec<Noise> CODEC = RTFBuiltInRegistries.NOISE_TYPE.m_194605_().dispatch(Noise::codec, Function.identity());
    public static final float MAX_REASONABLE_NOISE_VALUE = 1000000.0f;
    public static final Codec<Float> NOISE_VALUE_CODEC = Codec.floatRange((float)-1000000.0f, (float)1000000.0f);
    public static final Codec<Noise> DIRECT_CODEC = Codec.either(NOISE_VALUE_CODEC, CODEC).xmap(either -> (Noise)either.map(Noises::constant, Function.identity()), noise -> {
        if (noise instanceof Constant) {
            Constant constant = (Constant)noise;
            return Either.left((Object)Float.valueOf(constant.value()));
        }
        return Either.right((Object)noise);
    });

    public static void bootstrap() {
        Noises.register("constant", Constant.CODEC);
        Noises.register("sin", Sin.CODEC);
        Noises.register("white", White.CODEC);
        Noises.register("perlin", Perlin.CODEC);
        Noises.register("perlin2", Perlin2.CODEC);
        Noises.register("perlin_ridge", PerlinRidge.CODEC);
        Noises.register("simplex", Simplex.CODEC);
        Noises.register("simplex2", Simplex2.CODEC);
        Noises.register("simplex_ridge", SimplexRidge.CODEC);
        Noises.register("worley", Worley.CODEC);
        Noises.register("worley_edge", WorleyEdge.CODEC);
        Noises.register("billow", Billow.CODEC);
        Noises.register("cubic", Cubic.CODEC);
        Noises.register("line", Line.CODEC);
        Noises.register("shift", ShiftSeed.CODEC);
        Noises.register("frequency", Frequency.CODEC);
        Noises.register("add", Add.CODEC);
        Noises.register("multiply", Multiply.CODEC);
        Noises.register("power", Power.CODEC);
        Noises.register("power_curve", PowerCurve.CODEC);
        Noises.register("curve", Curve.CODEC);
        Noises.register("gradient", Gradient.CODEC);
        Noises.register("terrace", Terrace.CODEC);
        Noises.register("advanced_terrace", AdvancedTerrace.CODEC);
        Noises.register("invert", Invert.CODEC);
        Noises.register("blend", Blend.CODEC);
        Noises.register("alpha", Alpha.CODEC);
        Noises.register("boost", Boost.CODEC);
        Noises.register("steps", Steps.CODEC);
        Noises.register("abs", Abs.CODEC);
        Noises.register("map", Map.CODEC);
        Noises.register("clamp", Clamp.CODEC);
        Noises.register("threshold", Threshold.CODEC);
        Noises.register("min", Min.CODEC);
        Noises.register("max", Max.CODEC);
        Noises.register("warp", Warp.CODEC);
        Noises.register("erosion", Erosion.CODEC);
        Noises.register("linear_spline", LinearSpline.CODEC);
        Noises.register("cache", Cache2d.CODEC);
        Noises.register("legacy_temperature", LegacyTemperature.CODEC);
        Noises.register("legacy_moisture", LegacyMoisture.CODEC);
    }

    public static Noise constant(float value) {
        return new Constant(value);
    }

    public static Noise negative(Noise input) {
        return Noises.mul(input, -1.0f);
    }

    public static Noise zero() {
        return Noises.constant(0.0f);
    }

    public static Noise one() {
        return Noises.constant(1.0f);
    }

    public static Noise sin(int seed, float frequency, Noise alpha) {
        return Noises.shiftSeed(new Sin(frequency, alpha), seed);
    }

    public static Noise white(int seed, int scale) {
        return Noises.shiftSeed(new White(1.0f / (float)scale), seed);
    }

    public static Noise perlin(int seed, int scale, int octaves) {
        return Noises.perlin(seed, scale, octaves, 2.0f);
    }

    public static Noise perlin(int seed, int scale, int octaves, float lacunarity) {
        return Noises.perlin(seed, scale, octaves, lacunarity, 0.5f);
    }

    public static Noise perlin(int seed, int scale, int octaves, float lacunarity, float gain) {
        return new Perlin(seed, 1.0f / (float)scale, octaves, lacunarity, gain, Interpolation.CURVE3);
    }

    public static Noise perlin2(int seed, int scale, int octaves) {
        return Noises.perlin2(seed, scale, octaves, 2.0f);
    }

    public static Noise perlin2(int seed, int scale, int octaves, float lacunarity) {
        return Noises.perlin2(seed, scale, octaves, lacunarity, 0.5f);
    }

    public static Noise perlin2(int seed, int scale, int octaves, float lacunarity, float gain) {
        return new Perlin2(seed, 1.0f / (float)scale, octaves, lacunarity, gain, Interpolation.CURVE3);
    }

    public static Noise perlinRidge(int seed, int scale, int octaves) {
        return Noises.perlinRidge(seed, scale, octaves, 2.0f);
    }

    public static Noise perlinRidge(int seed, int scale, int octaves, float lacunarity) {
        return Noises.perlinRidge(seed, scale, octaves, lacunarity, 0.975f);
    }

    public static Noise perlinRidge(int seed, int scale, int octaves, float lacunarity, float gain) {
        return Noises.shiftSeed(new PerlinRidge(1.0f / (float)scale, octaves, lacunarity, gain, Interpolation.CURVE3), seed);
    }

    public static Noise simplex(int seed, int scale, int octaves) {
        return Noises.simplex(seed, scale, octaves, 2.0f);
    }

    public static Noise simplex(int seed, int scale, int octaves, float lacunarity) {
        return Noises.simplex(seed, scale, octaves, lacunarity, 0.5f);
    }

    public static Noise simplex(int seed, int scale, int octaves, float lacunarity, float gain) {
        return Noises.shiftSeed(new Simplex(1.0f / (float)scale, octaves, lacunarity, gain, Interpolation.CURVE3), seed);
    }

    public static Noise simplex2(int seed, int scale, int octaves) {
        return Noises.simplex2(seed, scale, octaves, 2.0f);
    }

    public static Noise simplex2(int seed, int scale, int octaves, float lacunarity) {
        return Noises.simplex2(seed, scale, octaves, lacunarity, 0.5f);
    }

    public static Noise simplex2(int seed, int scale, int octaves, float lacunarity, float gain) {
        return Noises.shiftSeed(new Simplex2(1.0f / (float)scale, octaves, lacunarity, gain, Interpolation.CURVE3), seed);
    }

    public static Noise simplexRidge(int seed, int scale, int octaves) {
        return Noises.simplexRidge(seed, scale, octaves, 2.0f);
    }

    public static Noise simplexRidge(int seed, int scale, int octaves, float lacunarity) {
        return Noises.simplexRidge(seed, scale, octaves, lacunarity, 0.975f);
    }

    public static Noise simplexRidge(int seed, int scale, int octaves, float lacunarity, float gain) {
        return Noises.shiftSeed(new SimplexRidge(1.0f / (float)scale, octaves, lacunarity, gain, Interpolation.CURVE3), seed);
    }

    public static Noise worley(int seed, int scale) {
        return Noises.worley(seed, scale, CellFunction.CELL_VALUE, DistanceFunction.EUCLIDEAN, Noises.zero());
    }

    public static Noise worley(int seed, int scale, CellFunction cellFunction, DistanceFunction distanceFunction, Noise lookup) {
        return Noises.shiftSeed(new Worley(1.0f / (float)scale, 1.0f, cellFunction, distanceFunction, lookup), seed);
    }

    public static Noise worleyEdge(int seed, int scale) {
        return Noises.worleyEdge(seed, scale, EdgeFunction.DISTANCE_2, DistanceFunction.EUCLIDEAN);
    }

    public static Noise worleyEdge(int seed, int scale, EdgeFunction edgeFunction, DistanceFunction distanceFunction) {
        return Noises.shiftSeed(new WorleyEdge(1.0f / (float)scale, 1.0f, edgeFunction, distanceFunction), seed);
    }

    public static Noise billow(int seed, int scale, int octaves) {
        return Noises.billow(seed, scale, octaves, 2.0f);
    }

    public static Noise billow(int seed, int scale, int octaves, float lacunarity) {
        return Noises.billow(seed, scale, octaves, lacunarity, 0.5f);
    }

    public static Noise billow(int seed, int scale, int octaves, float lacunarity, float gain) {
        return Noises.shiftSeed(new Billow(1.0f / (float)scale, octaves, lacunarity, gain, Interpolation.CURVE3), seed);
    }

    public static Noise cubic(int seed, int scale, int octaves) {
        return Noises.cubic(seed, scale, octaves, 2.0f);
    }

    public static Noise cubic(int seed, int scale, int octaves, float lacunarity) {
        return Noises.cubic(seed, scale, octaves, lacunarity, 0.5f);
    }

    public static Noise cubic(int seed, int scale, int octaves, float lacunarity, float gain) {
        return Noises.shiftSeed(new Cubic(1.0f / (float)scale, octaves, lacunarity, gain), seed);
    }

    public static Noise line(float x1, float z1, float x2, float z2, Noise radiusSq, Noise fadeIn, Noise fadeOut, float feather) {
        return new Line(x1, z1, x2, z2, radiusSq, fadeIn, fadeOut, feather);
    }

    public static Noise shiftSeed(Noise input, int seed) {
        return new ShiftSeed(input, seed);
    }

    public static Noise frequency(Noise input, float freq) {
        return Noises.frequency(input, freq, freq);
    }

    public static Noise frequency(Noise input, float xFreq, float zFreq) {
        return Noises.frequency(input, Noises.constant(xFreq), Noises.constant(zFreq));
    }

    public static Noise frequency(Noise input, Noise xFreq, Noise zFreq) {
        return new Frequency(input, xFreq, zFreq);
    }

    public static Noise add(Noise input1, float input2) {
        return Noises.add(input1, Noises.constant(input2));
    }

    public static Noise add(Noise input1, Noise input2) {
        return new Add(input1, input2);
    }

    public static Noise mul(Noise input1, float input2) {
        return Noises.mul(input1, Noises.constant(input2));
    }

    public static Noise mul(Noise input1, Noise input2) {
        return new Multiply(input1, input2);
    }

    public static Noise pow(Noise input, float pow) {
        return new Power(input, pow);
    }

    public static Noise powCurve(Noise input, float pow) {
        return new PowerCurve(input, pow);
    }

    public static Noise curve(Noise input, CurveFunction curveFunction) {
        return new Curve(input, curveFunction);
    }

    public static Noise gradient(Noise input, float lower, float upper, float strength) {
        return Noises.gradient(input, Noises.constant(lower), Noises.constant(upper), Noises.constant(strength));
    }

    public static Noise gradient(Noise input, Noise lower, Noise upper, Noise strength) {
        return new Gradient(input, lower, upper, strength);
    }

    public static Noise terrace(Noise input, float lowerCurve, float upperCurve, float lowerHeight, float blendRange, int steps) {
        return Noises.terrace(input, Noises.constant(lowerCurve), Noises.constant(upperCurve), Noises.constant(lowerHeight), blendRange, steps);
    }

    public static Noise terrace(Noise input, Noise lowerCurve, Noise upperCurve, Noise lowerHeight, float blendRange, int steps) {
        return new Terrace(input, lowerCurve, upperCurve, lowerHeight, blendRange, steps);
    }

    public static Noise advancedTerrace(Noise input, float modulation, float mask, float slope, float blendMin, float blendMax, int steps, int octaves) {
        return Noises.advancedTerrace(input, Noises.constant(modulation), Noises.constant(mask), Noises.constant(slope), blendMin, blendMax, steps, octaves);
    }

    public static Noise advancedTerrace(Noise input, Noise modulation, Noise mask, Noise slope, float blendMin, float blendMax, int steps, int octaves) {
        return new AdvancedTerrace(input, modulation, mask, slope, blendMin, blendMax, steps, octaves);
    }

    public static Noise invert(Noise input) {
        return new Invert(input);
    }

    public static Noise blend(Noise selector, Noise input1, Noise input2, float mid, float range) {
        return new Blend(selector, input1, input2, mid, range, Interpolation.LINEAR);
    }

    public static Noise alpha(Noise input, float alpha) {
        return Noises.alpha(input, Noises.constant(alpha));
    }

    public static Noise alpha(Noise input, Noise alpha) {
        return new Alpha(input, alpha);
    }

    public static Noise boost(Noise input) {
        return Noises.boost(input, 1);
    }

    public static Noise boost(Noise input, int iterations) {
        return new Boost(input, iterations);
    }

    public static Noise steps(Noise input, int steps, float slopeMin, float slopeMax) {
        return Noises.steps(input, steps, slopeMin, slopeMax, (CurveFunction)Interpolation.LINEAR);
    }

    public static Noise steps(Noise input, int steps, float slopeMin, float slopeMax, CurveFunction slopeCurve) {
        return Noises.steps(input, Noises.constant(steps), Noises.constant(slopeMin), Noises.constant(slopeMax), slopeCurve);
    }

    public static Noise steps(Noise input, Noise steps, Noise slopeMin, Noise slopeMax) {
        return new Steps(input, steps, slopeMin, slopeMax, Interpolation.LINEAR);
    }

    public static Noise steps(Noise input, Noise steps, Noise slopeMin, Noise slopeMax, CurveFunction slopeCurve) {
        return new Steps(input, steps, slopeMin, slopeMax, slopeCurve);
    }

    public static Noise abs(Noise input) {
        return new Abs(input);
    }

    public static Noise map(Noise input, float from, float to) {
        return Noises.map(input, Noises.constant(from), Noises.constant(to));
    }

    public static Noise map(Noise input, Noise from, Noise to) {
        if (from.minValue() == from.maxValue() && from.minValue() == input.minValue() && to.minValue() == to.maxValue() && to.maxValue() == input.maxValue()) {
            return input;
        }
        return new Map(input, from, to);
    }

    public static Noise clamp(Noise input, float min, float max) {
        return Noises.clamp(input, Noises.constant(min), Noises.constant(max));
    }

    public static Noise clamp(Noise input, Noise min, Noise max) {
        return new Clamp(input, min, max);
    }

    public static Noise threshold(Noise input, float lower, float upper, float threshold) {
        return Noises.threshold(input, Noises.constant(lower), Noises.constant(upper), Noises.constant(threshold));
    }

    public static Noise threshold(Noise input, Noise lower, Noise upper, float threshold) {
        return Noises.threshold(input, lower, upper, Noises.constant(threshold));
    }

    public static Noise threshold(Noise input, Noise lower, Noise upper, Noise threshold) {
        return new Threshold(input, lower, upper, threshold);
    }

    public static Noise min(Noise input1, float input2) {
        return Noises.min(input1, Noises.constant(input2));
    }

    public static Noise min(Noise input1, Noise input2) {
        return new Min(input1, input2);
    }

    public static Noise max(Noise input1, float input2) {
        return Noises.max(input1, Noises.constant(input2));
    }

    public static Noise max(Noise input1, Noise input2) {
        return new Max(input1, input2);
    }

    public static Noise warpPerlin(Noise input, int seed, int scale, int octaves, float pow) {
        return Noises.warp(input, Noises.perlin(seed, scale, octaves), Noises.perlin(seed + 1, scale, octaves), pow);
    }

    public static Noise warpWhite(Noise input, int seed, int scale, float pow) {
        return Noises.warp(input, Noises.white(seed, scale), Noises.white(seed + 1, scale), pow);
    }

    public static Noise warp(Noise input, Noise warpX, Noise warpZ, float pow) {
        return Noises.warp(input, warpX, warpZ, Noises.constant(pow));
    }

    public static Noise warp(Noise input, Noise warpX, Noise warpZ, Noise pow) {
        return Noises.warp(input, Domains.domain(warpX, warpZ, pow));
    }

    public static Noise warp(Noise input, Domain domain) {
        return new Warp(input, domain);
    }

    @Deprecated
    public static Noise cache2d(Noise input) {
        return new Cache2d(input);
    }

    public static Noise erosion(Noise input, int seed, int octaves, float strength, float gridSize, float amplitude, float lacunarity, float distanceFallOff, Erosion.BlendMode blendMode) {
        return new Erosion(input, seed, octaves, strength, gridSize, amplitude, lacunarity, distanceFallOff, blendMode);
    }

    private static void register(String name, Codec<? extends Noise> value) {
        RegistryUtil.register(RTFBuiltInRegistries.NOISE_TYPE, name, value);
    }

    public record HolderHolder(Holder<Noise> holder) implements Noise
    {
        @Override
        public float compute(float x, float z, int seed) {
            return ((Noise)this.holder.m_203334_()).compute(x, z, seed);
        }

        @Override
        public float minValue() {
            return this.holder.m_203633_() ? ((Noise)this.holder.m_203334_()).minValue() : Float.NEGATIVE_INFINITY;
        }

        @Override
        public float maxValue() {
            return this.holder.m_203633_() ? ((Noise)this.holder.m_203334_()).maxValue() : Float.POSITIVE_INFINITY;
        }

        @Override
        public Noise mapAll(Noise.Visitor visitor) {
            return visitor.apply(new HolderHolder((Holder<Noise>)Holder.m_205709_((Object)((Noise)this.holder.m_203334_()).mapAll(visitor))));
        }

        public Codec<HolderHolder> codec() {
            throw new UnsupportedOperationException("Called .codec() on HolderHolder");
        }
    }
}

