/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.noise.module;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import raccoonman.reterraforged.world.worldgen.noise.NoiseUtil;
import raccoonman.reterraforged.world.worldgen.noise.function.Interpolation;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;
import raccoonman.reterraforged.world.worldgen.noise.module.Simplex;

public record Simplex2(float frequency, int octaves, float lacunarity, float gain, Interpolation interpolation, float min, float max) implements Noise
{
    public static final Codec<Simplex2> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("frequency").forGetter(Simplex2::frequency), (App)Codec.INT.fieldOf("octaves").forGetter(Simplex2::octaves), (App)Codec.FLOAT.fieldOf("lacunarity").forGetter(Simplex2::lacunarity), (App)Codec.FLOAT.fieldOf("gain").forGetter(Simplex2::gain), (App)Interpolation.CODEC.fieldOf("interpolation").forGetter(Simplex2::interpolation)).apply((Applicative)instance, Simplex2::new));
    private static final float[] SIGNALS = new float[]{1.0f, 0.989f, 0.81f, 0.781f, 0.708f, 0.702f, 0.696f};

    public Simplex2(float frequency, int octaves, float lacunarity, float gain, Interpolation interpolation) {
        this(frequency, octaves, lacunarity, gain, interpolation, -Simplex2.max(octaves, gain), Simplex2.max(octaves, gain));
    }

    @Override
    public float compute(float x, float z, int seed) {
        x *= this.frequency;
        z *= this.frequency;
        float sum = 0.0f;
        float amp = 1.0f;
        for (int i = 0; i < this.octaves; ++i) {
            sum += Simplex2.sample(x, z, seed + i) * amp;
            x *= this.lacunarity;
            z *= this.lacunarity;
            amp *= this.gain;
        }
        return NoiseUtil.map(sum, this.min, this.max, this.max - this.min);
    }

    @Override
    public float minValue() {
        return 0.0f;
    }

    @Override
    public float maxValue() {
        return 1.0f;
    }

    @Override
    public Noise mapAll(Noise.Visitor visitor) {
        return visitor.apply(this);
    }

    public Codec<Simplex2> codec() {
        return CODEC;
    }

    public static float sample(float x, float y, int seed) {
        return Simplex.singleSimplex(x, y, seed, 99.83685f);
    }

    public static float max(int octaves, float gain) {
        float signal = Simplex2.signal(octaves);
        float sum = 0.0f;
        float amp = 1.0f;
        for (int i = 0; i < octaves; ++i) {
            sum += amp * signal;
            amp *= gain;
        }
        return sum;
    }

    private static float signal(int octaves) {
        int index = Math.min(octaves, SIGNALS.length - 1);
        return SIGNALS[index];
    }
}

