/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.noise.module;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import raccoonman.reterraforged.world.worldgen.noise.NoiseUtil;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;

public record White(float frequency) implements Noise
{
    public static final Codec<White> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("frequency").forGetter(White::frequency)).apply((Applicative)instance, White::new));

    @Override
    public float compute(float x, float z, int seed) {
        float value = White.sample(x *= this.frequency, z *= this.frequency, seed);
        return Math.abs(value);
    }

    @Override
    public float minValue() {
        return 0.0f;
    }

    @Override
    public float maxValue() {
        return 1.0f;
    }

    @Override
    public Noise mapAll(Noise.Visitor visitor) {
        return visitor.apply(this);
    }

    public Codec<White> codec() {
        return CODEC;
    }

    public static float sample(float x, float z, int seed) {
        int xi = NoiseUtil.round(x);
        int zi = NoiseUtil.round(z);
        return NoiseUtil.valCoord2D(seed, xi, zi);
    }

    public static float sample(float x, float z, int seed, int offset) {
        return White.sample(x, z, NoiseUtil.hash(seed, offset));
    }
}

