/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.noise.module;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import raccoonman.reterraforged.world.worldgen.noise.NoiseUtil;
import raccoonman.reterraforged.world.worldgen.noise.function.CellFunction;
import raccoonman.reterraforged.world.worldgen.noise.function.DistanceFunction;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;

record Worley(float frequency, float distance, CellFunction cellFunction, DistanceFunction distanceFunction, Noise lookup, float min, float max) implements Noise
{
    public static final Codec<Worley> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("frequency").forGetter(Worley::frequency), (App)Codec.FLOAT.fieldOf("distance").forGetter(Worley::distance), (App)CellFunction.CODEC.fieldOf("cell_function").forGetter(Worley::cellFunction), (App)DistanceFunction.CODEC.fieldOf("distance_function").forGetter(Worley::distanceFunction), (App)Noise.HOLDER_HELPER_CODEC.fieldOf("lookup").forGetter(Worley::lookup)).apply((Applicative)instance, Worley::new));

    public Worley(float frequency, float distance, CellFunction cellFunction, DistanceFunction distanceFunction, Noise lookup) {
        this(frequency, distance, cellFunction, distanceFunction, lookup, Worley.min(cellFunction, lookup), Worley.max(cellFunction, lookup));
    }

    @Override
    public float compute(float x, float z, int seed) {
        float value = Worley.sample(x *= this.frequency, z *= this.frequency, seed, this.distance, this.cellFunction, this.distanceFunction, this.lookup);
        return this.cellFunction.mapValue(value, this.min, this.max, this.max - this.min);
    }

    @Override
    public float minValue() {
        return 0.0f;
    }

    @Override
    public float maxValue() {
        return 1.0f;
    }

    @Override
    public Noise mapAll(Noise.Visitor visitor) {
        return visitor.apply(new Worley(this.frequency, this.distance, this.cellFunction, this.distanceFunction, this.lookup.mapAll(visitor)));
    }

    public Codec<Worley> codec() {
        return CODEC;
    }

    public static float sample(float x, float y, int seed, float distance, CellFunction cellFunction, DistanceFunction distanceFunction, Noise lookup) {
        int xi = NoiseUtil.floor(x);
        int yi = NoiseUtil.floor(y);
        int cellX = xi;
        int cellY = yi;
        NoiseUtil.Vec2f vec2f = null;
        float nearest = Float.MAX_VALUE;
        for (int dy = -1; dy <= 1; ++dy) {
            for (int dx = -1; dx <= 1; ++dx) {
                float deltaY;
                int cx = xi + dx;
                int cy = yi + dy;
                NoiseUtil.Vec2f vec = NoiseUtil.cell(seed, cx, cy);
                float deltaX = (float)cx + vec.x() * distance - x;
                float dist = distanceFunction.apply(deltaX, deltaY = (float)cy + vec.y() * distance - y);
                if (!(dist < nearest)) continue;
                nearest = dist;
                vec2f = vec;
                cellX = cx;
                cellY = cy;
            }
        }
        return cellFunction.apply(seed, cellX, cellY, nearest, vec2f, lookup);
    }

    private static float min(CellFunction function, Noise lookup) {
        if (function == CellFunction.NOISE_LOOKUP) {
            return lookup.minValue();
        }
        return -1.0f;
    }

    private static float max(CellFunction function, Noise lookup) {
        if (function == CellFunction.NOISE_LOOKUP) {
            return lookup.maxValue();
        }
        if (function == CellFunction.DISTANCE) {
            return 0.25f;
        }
        return 1.0f;
    }
}

