/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.structure.rule;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.RandomState;
import org.jetbrains.annotations.Nullable;
import raccoonman.reterraforged.world.worldgen.GeneratorContext;
import raccoonman.reterraforged.world.worldgen.RTFRandomState;
import raccoonman.reterraforged.world.worldgen.cell.Cell;
import raccoonman.reterraforged.world.worldgen.cell.heightmap.WorldLookup;
import raccoonman.reterraforged.world.worldgen.cell.terrain.Terrain;
import raccoonman.reterraforged.world.worldgen.cell.terrain.TerrainType;
import raccoonman.reterraforged.world.worldgen.structure.rule.StructureRule;

record CellTest(float cutoff, Set<Terrain> terrainTypeBlacklist) implements StructureRule
{
    public static final Codec<CellTest> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("cutoff").forGetter(CellTest::cutoff), (App)Codec.STRING.xmap(TerrainType::get, Terrain::getName).listOf().fieldOf("terrain_type_blacklist").forGetter(set -> set.terrainTypeBlacklist().stream().toList())).apply((Applicative)instance, CellTest::new));

    public CellTest(float cutoff, List<Terrain> terrainTypeBlacklist) {
        this(cutoff, (Set<Terrain>)ImmutableSet.copyOf(terrainTypeBlacklist));
    }

    @Override
    public boolean test(RandomState randomState, BlockPos pos) {
        RandomState randomState2 = randomState;
        if (randomState2 instanceof RTFRandomState) {
            RTFRandomState rtfRandomState = (RTFRandomState)randomState2;
            @Nullable GeneratorContext generatorContext = rtfRandomState.generatorContext();
            if (generatorContext != null) {
                WorldLookup worldLookup = generatorContext.lookup;
                Cell cell = new Cell();
                worldLookup.applyCell(cell.reset(), pos.m_123341_(), pos.m_123343_(), false);
                if (cell.riverMask < this.cutoff) {
                    return false;
                }
            }
            return true;
        }
        throw new IllegalStateException();
    }

    public Codec<CellTest> codec() {
        return CODEC;
    }
}

