/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.world.worldgen.surface.rule;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import org.jetbrains.annotations.Nullable;
import raccoonman.reterraforged.world.worldgen.RTFRandomState;
import raccoonman.reterraforged.world.worldgen.noise.NoiseUtil;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;
import raccoonman.reterraforged.world.worldgen.noise.module.Noises;
import raccoonman.reterraforged.world.worldgen.surface.RTFSurfaceSystem;

public record StrataRule(ResourceLocation name, Holder<Noise> selector, List<Strata> strata, int iterations) implements SurfaceRules.RuleSource
{
    public static final Codec<StrataRule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("name").forGetter(StrataRule::name), (App)Noise.CODEC.fieldOf("selector").forGetter(StrataRule::selector), (App)Strata.CODEC.listOf().fieldOf("strata").forGetter(StrataRule::strata), (App)Codec.INT.fieldOf("iterations").forGetter(StrataRule::iterations)).apply((Applicative)instance, StrataRule::new));

    public StrataRule {
        strata = ImmutableList.copyOf(strata);
    }

    public Source apply(SurfaceRules.Context ctx) {
        SurfaceSystem surfaceSystem = ctx.f_189535_;
        if (surfaceSystem instanceof RTFSurfaceSystem) {
            RTFSurfaceSystem rtfSurfaceSystem = (RTFSurfaceSystem)surfaceSystem;
            surfaceSystem = ctx.f_224614_;
            if (surfaceSystem instanceof RTFRandomState) {
                RTFRandomState rtfRandomState = (RTFRandomState)surfaceSystem;
                return new Source(ctx, rtfRandomState.seed((Noise)this.selector.m_203334_()), rtfSurfaceSystem.getOrCreateStrata(this.name, this::generateStrata));
            }
        }
        throw new IllegalStateException();
    }

    public KeyDispatchDataCodec<StrataRule> m_213795_() {
        return new KeyDispatchDataCodec(CODEC);
    }

    private List<List<Layer>> generateStrata(RandomSource random) {
        ArrayList<List<Layer>> layers = new ArrayList<List<Layer>>();
        for (int i = 0; i < this.iterations; ++i) {
            ArrayList<Layer> layer = new ArrayList<Layer>();
            for (Strata strata : this.strata) {
                layer.addAll(strata.generateLayers(random));
            }
            layers.add(layer);
        }
        return layers;
    }

    private class Source
    implements SurfaceRules.SurfaceRule {
        private SurfaceRules.Context surfaceContext;
        private Noise selector;
        private List<List<Layer>> strata;
        private List<Layer> layers;
        private float[] depthBuffer;
        private long lastUpdateXZ;

        public Source(SurfaceRules.Context surfaceContext, Noise selector, List<List<Layer>> strata) {
            this.surfaceContext = surfaceContext;
            this.selector = selector;
            this.strata = strata;
            this.lastUpdateXZ = Long.MIN_VALUE;
        }

        @Nullable
        public BlockState m_183550_(int x, int y, int z) {
            if (this.lastUpdateXZ != this.surfaceContext.f_189545_) {
                this.initBuffer(x, z);
                this.lastUpdateXZ = this.surfaceContext.f_189545_;
            }
            Layer last = null;
            for (int i = 0; i < this.layers.size(); ++i) {
                Layer layer = last = this.layers.get(i);
                if (!((float)y > this.depthBuffer[i])) continue;
                return layer.material();
            }
            return last != null ? last.material() : null;
        }

        private void initBuffer(int x, int z) {
            this.layers = this.selectLayers(x, z);
            int layerCount = this.layers.size();
            if (this.depthBuffer == null || this.depthBuffer.length < layerCount) {
                this.depthBuffer = new float[layerCount];
            }
            int localX = this.surfaceContext.f_189546_ & 0xF;
            int localZ = this.surfaceContext.f_189547_ & 0xF;
            int height = this.surfaceContext.f_189540_.m_5885_(Heightmap.Types.WORLD_SURFACE_WG, localX, localZ);
            float sum = 0.0f;
            for (int i = 0; i < layerCount; ++i) {
                Layer layer = this.layers.get(i);
                float depth = layer.computeDepth(x, z);
                sum += depth;
                this.depthBuffer[i] = depth;
            }
            int y = height;
            for (int i = 0; i < layerCount; ++i) {
                this.depthBuffer[i] = y -= Math.round(this.depthBuffer[i] / sum * (float)height);
            }
        }

        private List<Layer> selectLayers(int x, int z) {
            float selector = this.selector.compute(x, z, 0);
            int index = (int)(selector * (float)this.strata.size());
            index = Math.min(this.strata.size() - 1, index);
            return this.strata.get(index);
        }
    }

    public record Strata(TagKey<Block> materials, Holder<Noise> noise, int attempts, int minLayers, int maxLayers, float minDepth, float maxDepth) {
        public static final Codec<Strata> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TagKey.m_203886_((ResourceKey)Registries.f_256747_).fieldOf("materials").forGetter(Strata::materials), (App)Noise.CODEC.fieldOf("noise").forGetter(Strata::noise), (App)Codec.INT.fieldOf("attempts").forGetter(Strata::attempts), (App)Codec.INT.fieldOf("min_layers").forGetter(Strata::minLayers), (App)Codec.INT.fieldOf("max_layers").forGetter(Strata::maxLayers), (App)Codec.FLOAT.fieldOf("min_depth").forGetter(Strata::minDepth), (App)Codec.FLOAT.fieldOf("max_depth").forGetter(Strata::maxDepth)).apply((Applicative)instance, Strata::new));

        public List<Layer> generateLayers(RandomSource random) {
            int lastIndex = -1;
            int layers = this.minLayers + NoiseUtil.round(random.m_188501_() * (float)(this.maxLayers - this.minLayers));
            ArrayList<Layer> result = new ArrayList<Layer>();
            ImmutableList materials = ImmutableList.copyOf((Iterable)BuiltInRegistries.f_256975_.m_206058_(this.materials));
            int seed = random.m_188502_();
            for (int i = 0; i < layers; ++i) {
                int attempts = this.attempts;
                int index = random.m_188503_(materials.size());
                while (--attempts >= 0 && index == lastIndex) {
                    index = random.m_188503_(materials.size());
                }
                if (index == lastIndex) continue;
                lastIndex = index;
                BlockState material = ((Block)((Holder)materials.get(index)).m_203334_()).m_49966_();
                float depth = this.minDepth + random.m_188501_() * (this.maxDepth - this.minDepth);
                result.add(new Layer(material, Noises.shiftSeed(Noises.mul((Noise)this.noise.m_203334_(), depth), random.m_188502_()), seed));
            }
            return result;
        }
    }

    public record Layer(BlockState material, Noise depth, int seed) {
        public float computeDepth(float x, float z) {
            return this.depth.compute(x, z, this.seed);
        }
    }
}

