/*
 * Decompiled with CFR 0.152.
 */
package de.totodev.spellbooktweaks;

import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="spellbooktweaks", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AttributeRegistry {
    private static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"spellbooktweaks");
    public static final RegistryObject<Attribute> SPELL_PROFICIENCY = ATTRIBUTES.register("spell_proficiency", () -> new RangedAttribute("attribute.spellbooktweaks.spell_proficiency", 0.0, 0.0, 9.0).m_22084_(true));
    public static final RegistryObject<Attribute> FIRE_SCHOOL_PROFICIENCY = AttributeRegistry.newSchoolProficiencyAttribute("fire");
    public static final RegistryObject<Attribute> ICE_SCHOOL_PROFICIENCY = AttributeRegistry.newSchoolProficiencyAttribute("ice");
    public static final RegistryObject<Attribute> LIGHTNING_SCHOOL_PROFICIENCY = AttributeRegistry.newSchoolProficiencyAttribute("lightning");
    public static final RegistryObject<Attribute> HOLY_SCHOOL_PROFICIENCY = AttributeRegistry.newSchoolProficiencyAttribute("holy");
    public static final RegistryObject<Attribute> ENDER_SCHOOL_PROFICIENCY = AttributeRegistry.newSchoolProficiencyAttribute("ender");
    public static final RegistryObject<Attribute> BLOOD_SCHOOL_PROFICIENCY = AttributeRegistry.newSchoolProficiencyAttribute("blood");
    public static final RegistryObject<Attribute> EVOCATION_SCHOOL_PROFICIENCY = AttributeRegistry.newSchoolProficiencyAttribute("evocation");
    public static final RegistryObject<Attribute> NATURE_SCHOOL_PROFICIENCY = AttributeRegistry.newSchoolProficiencyAttribute("nature");

    public static void register(IEventBus eventBus) {
        ATTRIBUTES.register(eventBus);
    }

    @SubscribeEvent
    public static void modifyEntityAttributes(EntityAttributeModificationEvent e) {
        e.getTypes().forEach(entity -> {
            e.add(entity, (Attribute)SPELL_PROFICIENCY.get());
            e.add(entity, (Attribute)FIRE_SCHOOL_PROFICIENCY.get());
            e.add(entity, (Attribute)ICE_SCHOOL_PROFICIENCY.get());
            e.add(entity, (Attribute)LIGHTNING_SCHOOL_PROFICIENCY.get());
            e.add(entity, (Attribute)HOLY_SCHOOL_PROFICIENCY.get());
            e.add(entity, (Attribute)ENDER_SCHOOL_PROFICIENCY.get());
            e.add(entity, (Attribute)BLOOD_SCHOOL_PROFICIENCY.get());
            e.add(entity, (Attribute)EVOCATION_SCHOOL_PROFICIENCY.get());
            e.add(entity, (Attribute)NATURE_SCHOOL_PROFICIENCY.get());
        });
    }

    private static RegistryObject<Attribute> newSchoolProficiencyAttribute(String id) {
        return ATTRIBUTES.register(id + "_school_proficiency", () -> new RangedAttribute("attribute.spellbooktweaks." + id + "_school_proficiency", 0.0, 0.0, 9.0).m_22084_(true));
    }
}

