/*
 * Decompiled with CFR 0.152.
 */
package de.totodev.spellbooktweaks.mixin;

import de.totodev.spellbooktweaks.AttributeRegistry;
import io.redspace.ironsspellbooks.api.item.curios.AffinityData;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastResult;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.theillusivec4.curios.api.CuriosApi;

@Mixin(value={AbstractSpell.class})
public abstract class AbstractSpellMixin {
    @Shadow(remap=false)
    public abstract SpellRarity getRarity(int var1);

    @Shadow(remap=false)
    public abstract MutableComponent getDisplayName(Player var1);

    @Shadow(remap=false)
    public abstract SchoolType getSchoolType();

    @Redirect(method={"getLevelFor"}, at=@At(value="INVOKE", target="Ljava/util/List;size()I"), remap=false)
    private int getLevelForIgnoreAffinity(List self) {
        return 0;
    }

    @Inject(method={"canBeCastedBy(ILio/redspace/ironsspellbooks/api/spells/CastSource;Lio/redspace/ironsspellbooks/api/magic/MagicData;Lnet/minecraft/world/entity/player/Player;)Lio/redspace/ironsspellbooks/api/spells/CastResult;"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void canBeCastedBy(int spellLevel, CastSource castSource, MagicData playerMagicData, Player player, CallbackInfoReturnable<CastResult> cir) {
        String schoolName = this.getSchoolType().getId().m_135815_();
        double exactProficiency = this.spellbookTweaks$getSchoolProficiency(player, schoolName);
        int proficiency = (int)exactProficiency;
        if (!CuriosApi.getCuriosHelper().findCurios((LivingEntity)player, itemStack -> AffinityData.hasAffinityData((ItemStack)itemStack) && AffinityData.getAffinityData((ItemStack)itemStack).getSpell().equals((Object)this)).isEmpty()) {
            return;
        }
        SpellRarity spellRarity = this.getRarity(spellLevel);
        if (proficiency < spellRarity.getValue() * 3) {
            String prettyProficiency = exactProficiency == (double)proficiency ? String.valueOf(proficiency) : String.valueOf(exactProficiency);
            cir.setReturnValue((Object)new CastResult(CastResult.Type.FAILURE, (Component)Component.m_237110_((String)"ui.spellbooktweaks.cast_error_rarity", (Object[])new Object[]{schoolName.equals("eldritch") ? "spell" : schoolName, this.getDisplayName(player), prettyProficiency, spellRarity.getValue() * 3}).m_130940_(ChatFormatting.RED)));
        }
    }

    @Unique
    private double spellbookTweaks$getSchoolProficiency(Player player, String schoolName) {
        double proficiency = switch (schoolName) {
            case "fire" -> player.m_21133_((Attribute)AttributeRegistry.FIRE_SCHOOL_PROFICIENCY.get());
            case "ice" -> player.m_21133_((Attribute)AttributeRegistry.ICE_SCHOOL_PROFICIENCY.get());
            case "lightning" -> player.m_21133_((Attribute)AttributeRegistry.LIGHTNING_SCHOOL_PROFICIENCY.get());
            case "holy" -> player.m_21133_((Attribute)AttributeRegistry.HOLY_SCHOOL_PROFICIENCY.get());
            case "ender" -> player.m_21133_((Attribute)AttributeRegistry.ENDER_SCHOOL_PROFICIENCY.get());
            case "blood" -> player.m_21133_((Attribute)AttributeRegistry.BLOOD_SCHOOL_PROFICIENCY.get());
            case "evocation" -> player.m_21133_((Attribute)AttributeRegistry.EVOCATION_SCHOOL_PROFICIENCY.get());
            case "nature" -> player.m_21133_((Attribute)AttributeRegistry.NATURE_SCHOOL_PROFICIENCY.get());
            case "eldritch" -> {
                double maxProficiency = 0.0;
                maxProficiency = Math.max(maxProficiency, player.m_21133_((Attribute)AttributeRegistry.FIRE_SCHOOL_PROFICIENCY.get()));
                maxProficiency = Math.max(maxProficiency, player.m_21133_((Attribute)AttributeRegistry.ICE_SCHOOL_PROFICIENCY.get()));
                maxProficiency = Math.max(maxProficiency, player.m_21133_((Attribute)AttributeRegistry.LIGHTNING_SCHOOL_PROFICIENCY.get()));
                maxProficiency = Math.max(maxProficiency, player.m_21133_((Attribute)AttributeRegistry.HOLY_SCHOOL_PROFICIENCY.get()));
                maxProficiency = Math.max(maxProficiency, player.m_21133_((Attribute)AttributeRegistry.ENDER_SCHOOL_PROFICIENCY.get()));
                maxProficiency = Math.max(maxProficiency, player.m_21133_((Attribute)AttributeRegistry.BLOOD_SCHOOL_PROFICIENCY.get()));
                maxProficiency = Math.max(maxProficiency, player.m_21133_((Attribute)AttributeRegistry.EVOCATION_SCHOOL_PROFICIENCY.get()));
                yield maxProficiency = Math.max(maxProficiency, player.m_21133_((Attribute)AttributeRegistry.NATURE_SCHOOL_PROFICIENCY.get()));
            }
            default -> 0.0;
        };
        return proficiency += player.m_21133_((Attribute)AttributeRegistry.SPELL_PROFICIENCY.get());
    }
}

